/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.StrUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.constant.e.CookieConstEnum;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u83b7\u53d6\u6709\u5173\u6a21\u7248\u6587\u4ef6\u5939\u6216\u6a21\u7248\u6587\u4ef6\u4fe1\u606f")
@Controller(value="/basicTemplate")
@RequestMapping(value={"/${ms.manager.path}/template"})
public class TemplateAction
extends BaseAction {
    @Autowired
    private IAppBiz appBiz;
    @Value(value="${ms.upload.template}")
    private String uploadTemplatePath;
    @Value(value="${ms.upload.denied}")
    private String uploadFileDenied;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/template/index";
    }

    @ApiOperation(value="\u70b9\u51fb\u6a21\u7248\u7ba1\u7406\uff0c\u83b7\u53d6\u6240\u6709\u7684\u6a21\u7248\u6587\u4ef6\u540d")
    @ApiImplicitParam(name="pageNo", value="pageNo", required=true, paramType="query")
    @GetMapping(value={"/queryTemplateSkin"})
    @ResponseBody
    protected ResultData queryTemplateSkin(HttpServletResponse response, HttpServletRequest request) {
        String pageNo = request.getParameter("pageNo");
        if (!NumberUtils.isNumber((String)pageNo)) {
            pageNo = "1";
        }
        ManagerSessionEntity managerSession = this.getManagerBySession();
        List<String> folderNameList = this.queryTemplateFile();
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("folderNameList", folderNameList);
        map.put("websiteId", BasicUtil.getApp().getAppId());
        int recordCount = 0;
        if (folderNameList != null) {
            recordCount = folderNameList.size();
        }
        map.put("pageNo", pageNo);
        BasicUtil.setCookie(response, CookieConstEnum.PAGENO_COOKIE, pageNo);
        return ResultData.build().success(map);
    }

    @ApiOperation(value="\u89e3\u538bzip\u6a21\u7248\u6587\u4ef6")
    @ApiImplicitParam(name="fileUrl", value="\u6587\u4ef6\u8def\u5f84", required=true, paramType="query")
    @LogAnn(title="\u89e3\u538bzip\u6a21\u7248\u6587\u4ef6", businessType=BusinessTypeEnum.OTHER)
    @GetMapping(value={"/unZip"})
    @ResponseBody
    @RequiresPermissions(value={"template:upload"})
    public ResultData unZip(@ApiIgnore ModelMap model, HttpServletRequest request) throws IOException {
        String entryName = "";
        String fileUrl = request.getParameter("fileUrl");
        if (fileUrl != null && (fileUrl.contains("../") || fileUrl.contains("..\\"))) {
            ResultData.build().error();
        }
        File file = new File(BasicUtil.getRealTemplatePath(fileUrl));
        this.unZip(file, new File(BasicUtil.getRealTemplatePath(fileUrl.substring(0, fileUrl.length() - file.getName().length()))), Charset.forName("GBK"));
        FileUtils.forceDelete((File)file);
        return ResultData.build().success((Object)entryName);
    }

    @GetMapping(value={"/list"})
    public String list(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/template/list";
    }

    @ApiOperation(value="\u5199\u5165\u6a21\u7248\u6587\u4ef6\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="oldFileName", value="\u65e7\u6587\u4ef6\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="fileContent", value="\u6587\u4ef6\u5185\u5bb9", required=true, paramType="query")})
    @LogAnn(title="\u5199\u5165\u6a21\u7248\u6587\u4ef6\u5185\u5bb9", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/writeFileContent"})
    @ResponseBody
    public ResultData writeFileContent(@ApiIgnore ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = request.getParameter("fileName");
        if (!this.checkFileType(fileName)) {
            return ResultData.build().error();
        }
        String oldFileName = request.getParameter("oldFileName");
        String fileContent = request.getParameter("fileContent");
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            String templets = BasicUtil.getRealTemplatePath(fileName);
            this.LOG.debug(templets);
            FileWriter.create((File)new File(templets)).write(fileContent);
            if (!fileName.equals(oldFileName)) {
                File newName = new File(templets);
                File oldName = new File(BasicUtil.getRealTemplatePath(oldFileName));
                oldName.renameTo(newName);
                FileUtil.del((String)BasicUtil.getRealTemplatePath(oldFileName));
            }
            return ResultData.build().success();
        }
        return ResultData.build().error();
    }

    @ApiOperation(value="\u5220\u9664\u6a21\u7248")
    @ApiImplicitParam(name="fileName", value="\u6a21\u7248\u540d\u79f0", required=true, paramType="query")
    @LogAnn(title="\u5220\u9664\u6a21\u7248", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"template:del"})
    public ResultData delete(HttpServletRequest request) {
        String fileName = request.getParameter("fileName");
        String path = BasicUtil.getRealTemplatePath(this.uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId() + File.separator + fileName);
        try {
            FileUtils.deleteQuietly((File)new File(path));
            return ResultData.build().success();
        }
        catch (Exception e) {
            return ResultData.build().error();
        }
    }

    @ApiOperation(value="\u663e\u793a\u5b50\u6587\u4ef6\u548c\u5b50\u6587\u4ef6\u5939")
    @ApiImplicitParam(name="skinFolderName", value="skinFolderName", required=true, paramType="query")
    @GetMapping(value={"/showChildFileAndFolder"})
    @ResponseBody
    public ResultData showChildFileAndFolder(HttpServletResponse response, HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession();
        ArrayList<String> folderNameList = null;
        String skinFolderName = request.getParameter("skinFolderName");
        String filter = BasicUtil.getRealTemplatePath(this.uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId());
        this.LOG.debug("\u8fc7\u6ee4\u8def\u5f84" + filter);
        if (skinFolderName != null && (skinFolderName.contains("../") || skinFolderName.contains("..\\"))) {
            return ResultData.build().error("\u975e\u6cd5\u8def\u5f84");
        }
        skinFolderName = this.uploadTemplatePath + File.separator + skinFolderName;
        File[] files = new File(BasicUtil.getRealTemplatePath(skinFolderName)).listFiles();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (files != null) {
            folderNameList = new ArrayList<String>();
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (int i = 0; i < files.length; ++i) {
                File currFile = files[i];
                String temp = currFile.getPath();
                temp = temp.replace(File.separator.equals("\\") ? "/" : "\\", File.separator).replace(filter, "");
                if (currFile.isDirectory()) {
                    folderNameList.add(temp);
                    continue;
                }
                fileNameList.add(temp);
            }
            map.put("folderNum", folderNameList.size());
            folderNameList.addAll(fileNameList);
            map.put("fileNameList", folderNameList);
        }
        String uploadFileUrl = skinFolderName;
        map.put("uploadFileUrl", uploadFileUrl);
        map.put("websiteId", BasicUtil.getApp().getAppId());
        return ResultData.build().success(map);
    }

    @ApiOperation(value="\u8bfb\u53d6\u6a21\u7248\u6587\u4ef6\u5185\u5bb9")
    @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query")
    @GetMapping(value={"/readFileContent"})
    @ResponseBody
    @RequiresPermissions(value={"template:update"})
    public ResultData readFileContent(@ApiIgnore ModelMap model, HttpServletRequest request) {
        String fileName = request.getParameter("fileName");
        if (fileName != null && (fileName.contains("../") || fileName.contains("..\\"))) {
            return ResultData.build().error("\u975e\u6cd5\u8def\u5f84");
        }
        fileName = this.uploadTemplatePath + File.separator + fileName;
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            map.put("fileContent", FileReader.create((File)new File(BasicUtil.getRealTemplatePath(fileName))).readString());
        }
        map.put("name", new File(BasicUtil.getRealTemplatePath(fileName)).getName());
        map.put("fileName", fileName);
        map.put("fileNamePrefix", fileName.substring(0, fileName.lastIndexOf(File.separator) + 1));
        return ResultData.build().success(map);
    }

    @ApiOperation(value="\u5220\u9664\u6a21\u7248\u6587\u4ef6")
    @ApiImplicitParam(name="fileName", value="\u6587\u4ef6\u540d\u79f0", required=true, paramType="query")
    @LogAnn(title="\u5220\u9664\u6a21\u7248\u6587\u4ef6", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/deleteTemplateFile"})
    @ResponseBody
    public ResultData deleteTemplateFile(HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession();
        String fileName = request.getParameter("fileName");
        if (fileName != null && (fileName.contains("../") || fileName.contains("..\\"))) {
            return ResultData.build().error("\u975e\u6cd5\u8def\u5f84");
        }
        fileName = this.uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId() + File.separator + fileName;
        FileUtil.del((String)BasicUtil.getRealTemplatePath(fileName));
        return ResultData.build().success();
    }

    @GetMapping(value={"/edit"})
    public String edit(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/template/edit";
    }

    private void files(List list, File fileDir, String style) {
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File currFile = files[i];
                if (currFile.isFile()) {
                    String ex = currFile.getName();
                    if (!ex.endsWith("htm") && !ex.endsWith("html")) continue;
                    String _pathName = new String();
                    _pathName = this.files(currFile, style, _pathName);
                    list.add(_pathName + currFile.getName());
                    continue;
                }
                if (!currFile.isDirectory()) continue;
                this.files(list, currFile, style);
            }
        }
    }

    private String files(File file, String style, String pathName) {
        if (!file.getParentFile().getName().equals(style)) {
            pathName = file.getParentFile().getName() + "/" + pathName;
            pathName = this.files(file.getParentFile(), style, pathName);
        }
        return pathName;
    }

    private List<String> queryTemplateFile() {
        String templets;
        File file;
        String[] str;
        ArrayList<String> folderNameList = null;
        if (!this.isSystemManager() && (str = (file = new File(templets = BasicUtil.getRealTemplatePath(this.uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId() + File.separator))).list()) != null) {
            folderNameList = new ArrayList<String>();
            for (int i = 0; i < str.length; ++i) {
                if (str[i].indexOf(".") >= 0) continue;
                folderNameList.add(str[i]);
            }
        }
        return folderNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File unZip(File file, File outFile, Charset charset) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(file, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        try {
            Enumeration<? extends ZipEntry> em = zipFile.entries();
            ZipEntry zipEntry = null;
            File outItemFile = null;
            while (em.hasMoreElements()) {
                zipEntry = em.nextElement();
                String name = zipEntry.getName();
                if (!FileUtil.isWindows() && name.lastIndexOf(47, name.length() - 2) > 0) {
                    String[] pathParts = StrUtil.splitToArray((CharSequence)name, (char)'/');
                    for (int i = 0; i < pathParts.length - 1; ++i) {
                        outFile = new File(outFile, pathParts[i]);
                    }
                    outFile.mkdirs();
                    name = pathParts[pathParts.length - 1];
                }
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    outItemFile = FileUtil.file((File)outFile, (String)name);
                }
                if (zipEntry.isDirectory()) {
                    if (outItemFile == null) continue;
                    outItemFile.mkdirs();
                    continue;
                }
                InputStream in = null;
                try {
                    if (!this.checkFileType(zipEntry.getName())) {
                        File i = null;
                        return i;
                    }
                    in = zipFile.getInputStream(zipEntry);
                    FileUtil.writeFromStream((InputStream)in, (File)outItemFile);
                    IoUtil.close((Closeable)in);
                }
                catch (IOException e) {
                    throw new IORuntimeException((Throwable)e);
                }
                finally {
                    IoUtil.close(in);
                }
            }
            File file2 = outFile;
            return file2;
        }
        finally {
            IoUtil.close((Closeable)zipFile);
        }
    }

    protected boolean checkFileType(String fileName) {
        String[] errorType = this.uploadFileDenied.split(",");
        String fileType = fileName.substring(fileName.lastIndexOf("."));
        for (String type : errorType) {
            if (!fileType.equalsIgnoreCase(type)) continue;
            this.LOG.info("\u6587\u4ef6\u7c7b\u578b\u88ab\u62d2\u7edd:{}", (Object)fileName);
            return false;
        }
        return true;
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u7248\u98ce\u683c\u4f9b\u7ad9\u70b9\u9009\u62e9")
    @GetMapping(value={"/queryAppTemplateSkin"})
    @ResponseBody
    public ResultData queryAppTemplateSkin(HttpServletRequest request) {
        List<String> folderNameList = this.queryTemplateFile();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (folderNameList != null) {
            map.put("appTemplates", folderNameList);
        }
        return ResultData.build().success(map);
    }

    @ApiOperation(value="\u67e5\u8be2\u6a21\u7248\u6587\u4ef6\u4f9b\u680f\u76ee\u9009\u62e9\uff0c\u53ef\u6307\u5b9a\u6a21\u677f\u540d\u79f0\uff0c\u4e0d\u4f20\u67e5\u8be2\u5e94\u7528\u8bbe\u7f6e\u4e2d\u9009\u62e9\u7684\u6a21\u677f")
    @GetMapping(value={"/queryTemplateFileForColumn"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="appStyle", value="\u6a21\u677f\u540d\u79f0", required=false, paramType="query")})
    @ResponseBody
    public ResultData queryTemplateFileForColumn(HttpServletRequest request) {
        String appStyle = BasicUtil.getString("appStyle", BasicUtil.getApp().getAppStyle());
        String path = BasicUtil.getRealTemplatePath(this.uploadTemplatePath + File.separator + BasicUtil.getApp().getAppId() + File.separator);
        List list = FileUtil.loopFiles((String)(path + appStyle), (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return FileTypeUtil.getType((File)pathname).equalsIgnoreCase("html") || FileTypeUtil.getType((File)pathname).equalsIgnoreCase("htm");
            }
        });
        List collect = list.stream().map(file -> file.getPath().split(File.separator + appStyle + File.separator)[1]).collect(Collectors.toList());
        return ResultData.build().success(collect);
    }
}

