/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mingsoft.base.util.BundleUtil;
import net.mingsoft.basic.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class SqlInjectionUtil {
    private static Logger LOG = LoggerFactory.getLogger(SqlInjectionUtil.class);
    private static final String xssStr = "'|and |exec |insert |select |delete |update |drop |count |chr |mid |master |truncate |char |declare |;|or |+|,";
    private static final String reg = "(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)";
    private static final Pattern sqlPattern = Pattern.compile("(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)", 2);

    public static void filterContent(String value) {
        if (value == null || "".equals(value)) {
            return;
        }
        value = value.toLowerCase();
        String[] xssArr = xssStr.split("\\|");
        for (int i = 0; i < xssArr.length; ++i) {
            if (value.indexOf(xssArr[i]) <= -1) continue;
            LOG.info("\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> {}", (Object)xssArr[i]);
            LOG.info("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> {}", (Object)value);
            throw new BusinessException(HttpStatus.NOT_ACCEPTABLE, BundleUtil.getLocaleString((String)"sql.param.illegal", (String)"net.mingsoft.basic.resources.resources"));
        }
    }

    public static void filterContent(String[] values) {
        String[] xssArr = xssStr.split("\\|");
        for (String value : values) {
            if (value == null || "".equals(value)) continue;
            value = value.toLowerCase();
            for (int i = 0; i < xssArr.length; ++i) {
                if (value.indexOf(xssArr[i]) <= -1) continue;
                LOG.info("\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> {}", (Object)xssArr[i]);
                LOG.info("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> {}", (Object)value);
                throw new BusinessException(HttpStatus.NOT_ACCEPTABLE, BundleUtil.getLocaleString((String)"sql.param.illegal", (String)"net.mingsoft.basic.resources.resources"));
            }
        }
    }

    public static boolean isSqlValid(String str) {
        Matcher matcher = sqlPattern.matcher(str);
        if (matcher.find()) {
            LOG.info("\u53c2\u6570\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\uff0c\u8bf7\u786e\u8ba4\uff1a" + matcher.group());
            return false;
        }
        return true;
    }
}

