/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.bean.RoleBean;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.entity.RoleEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/role"})
public class RoleAction
extends BaseAction {
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @ApiIgnore
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"role:view"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/role/index";
    }

    @ApiOperation(value="\u8fd4\u56de\u7f16\u8f91\u754c\u9762role_form")
    @ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, paramType="query")
    @GetMapping(value={"/form"})
    @RequiresPermissions(value={"role:view"})
    public String form(@ModelAttribute @ApiIgnore RoleEntity role, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isNotEmpty((CharSequence)role.getId())) {
            RoleEntity roleEntity = (RoleEntity)((Object)this.roleBiz.getById((Serializable)((Object)role.getId())));
            model.addAttribute("roleEntity", (Object)roleEntity);
        }
        return "/basic/role/form";
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="managerId", value="\u8be5\u89d2\u8272\u7684\u521b\u5efa\u8005ID", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore RoleEntity role, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        BasicUtil.startPage();
        List roleList = this.roleBiz.query(role);
        return ResultData.build().success((Object)new EUListBean(roleList, (int)BasicUtil.endPage(roleList).getTotal()));
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u6a21\u5757\u96c6\u5408")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true, paramType="path")
    @GetMapping(value={"/{roleId}/queryByRole"})
    @ResponseBody
    public ResultData queryByRole(@PathVariable @ApiIgnore int roleId, HttpServletResponse response) {
        List<ModelEntity> models = this.modelBiz.queryModelByRoleId(roleId);
        return ResultData.build().success(models);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u89d2\u8272\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="managerId", value="\u8be5\u89d2\u8272\u7684\u521b\u5efa\u8005ID", required=false, paramType="query")})
    @GetMapping(value={"/all"})
    @ResponseBody
    public ResultData all(@ModelAttribute @ApiIgnore RoleEntity role, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        BasicUtil.startPage();
        List roleList = this.roleBiz.query(role);
        return ResultData.build().success((Object)new EUListBean(roleList, (int)BasicUtil.endPage(roleList).getTotal()));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272")
    @ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"role:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore RoleEntity role, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)role.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("role.id")}));
        }
        RoleEntity _role = (RoleEntity)this.roleBiz.getEntity(Integer.parseInt(role.getId()));
        return ResultData.build().success((Object)_role);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleName", value="\u89d2\u8272\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="managerId", value="\u8be5\u89d2\u8272\u7684\u521b\u5efa\u8005ID", required=false, paramType="query")})
    @LogAnn(title="\u4fdd\u5b58\u89d2\u8272\u5b9e\u4f53", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/saveOrUpdateRole"})
    @ResponseBody
    @RequiresPermissions(value={"role:save"})
    public ResultData saveOrUpdateRole(@ModelAttribute @ApiIgnore RoleBean role, HttpServletResponse response, HttpServletRequest request) {
        RoleBean _role = new RoleBean();
        _role.setRoleName(role.getRoleName());
        ManagerEntity managerSession = BasicUtil.getManager();
        if (StringUtils.isEmpty((CharSequence)role.getRoleName())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("rolrName")}));
        }
        RoleBean roleBean = (RoleBean)((Object)this.roleBiz.getEntity(_role));
        if (StringUtils.isNotEmpty((CharSequence)role.getId())) {
            if (roleBean != null && !roleBean.getId().equals(role.getId())) {
                return ResultData.build().error(this.getResString("roleName.exist"));
            }
            role.setUpdateBy(BasicUtil.getManager().getId());
            role.setUpdateDate(new Date());
            role.setCreateBy(null);
            this.roleBiz.updateById((Object)role);
        } else {
            if (roleBean != null) {
                return ResultData.build().error(this.getResString("roleName.exist"));
            }
            role.setCreateBy(BasicUtil.getManager().getId());
            role.setCreateDate(new Date());
            this.roleBiz.save((Object)role);
            this.roleBiz.updateCache();
        }
        ArrayList<RoleModelEntity> roleModelList = new ArrayList<RoleModelEntity>();
        if (!StringUtils.isEmpty((CharSequence)role.getIds())) {
            for (String id : role.getIds().split(",")) {
                RoleModelEntity roleModel = new RoleModelEntity();
                roleModel.setRoleId(Integer.parseInt(role.getId()));
                roleModel.setModelId(Integer.parseInt(id));
                roleModelList.add(roleModel);
            }
            this.roleModelBiz.deleteByRoleId(Integer.parseInt(role.getId()));
            this.modelBiz.updateCache();
            this.roleModelBiz.saveBatch(roleModelList, roleModelList.size());
        } else {
            this.roleModelBiz.deleteByRoleId(Integer.parseInt(role.getId()));
        }
        this.roleBiz.updateCache();
        return ResultData.build().success((Object)role);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u89d2\u8272")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"role:del"})
    @LogAnn(title="\u5220\u9664\u89d2\u8272", businessType=BusinessTypeEnum.DELETE)
    public ResultData delete(@RequestBody List<RoleEntity> roles, HttpServletResponse response, HttpServletRequest request) {
        ManagerEntity managerSession = BasicUtil.getManager();
        if (this.roleBiz.deleteRoleByRoles(roles, managerSession)) {
            return ResultData.build().success("\u5220\u9664\u6210\u529f", null);
        }
        return ResultData.build().success("\u5220\u9664\u6210\u529f\uff0c\u5df2\u8fc7\u6ee4\u5f53\u524d\u4e0d\u53ef\u5220\u9664\u89d2\u8272", null);
    }
}

