/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.exception;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.util.BundleUtil;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.CalculationUtil;
import net.mingsoft.config.MSProperties;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.session.ExpiredSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

@ControllerAdvice
public class GlobalExceptionResolver
extends DefaultHandlerExceptionResolver {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @ExceptionHandler(value={BusinessException.class})
    public ModelAndView handleBusinessException(HttpServletRequest request, HttpServletResponse response, BusinessException e) {
        this.LOG.debug("handleBusinessException");
        response.setStatus(e.getCode().value());
        return this.render(request, response, ResultData.build().code(e.getCode()).data(e.getData()).msg(e.getMsg()), e);
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        this.LOG.debug("handleException");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg(e.getStackTrace()[0].toString().concat(":").concat(e.toString())), e);
    }

    @ExceptionHandler(value={BadSqlGrammarException.class})
    public ModelAndView handleSqlException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        this.LOG.debug("handleSqlException");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg(e.getClass().toString()), e);
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ModelAndView uploadException(HttpServletRequest request, HttpServletResponse response, MaxUploadSizeExceededException e) throws IOException {
        this.LOG.debug("MaxUploadSizeExceededException");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg(BundleUtil.getString((String)"net.mingsoft.basic.resources.resources", (String)"upload.max.size", (String[])new String[]{CalculationUtil.convertSpaceUnit(MSProperties.upload.multipart.maxFileSize)})), (Exception)e);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ModelAndView handleNoHandlerFoundException(HttpServletRequest request, HttpServletResponse response, NoHandlerFoundException e) {
        this.LOG.debug("handleNoHandlerFoundException");
        return this.render(request, response, ResultData.build().code(HttpStatus.NOT_FOUND).msg("\u8d44\u6e90\u4e0d\u5b58\u5728"), (Exception)e);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ModelAndView handleMissingServletRequestParameterException(HttpServletRequest request, HttpServletResponse response, MissingServletRequestParameterException e) {
        this.LOG.debug("handleMissingServletRequestParameterException");
        return this.render(request, response, ResultData.build().code(HttpStatus.BAD_REQUEST).msg("request parameter err"), (Exception)e);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ModelAndView handleHttpRequestMethodNotSupportedException(HttpServletRequest request, HttpServletResponse response, HttpRequestMethodNotSupportedException e) {
        this.LOG.debug("handleHttpRequestMethodNotSupportedException");
        return this.render(request, response, ResultData.build().code(HttpStatus.METHOD_NOT_ALLOWED).msg("request method not support"), (Exception)e);
    }

    @ExceptionHandler(value={BindException.class})
    public ModelAndView handleValidExceptionHandler(HttpServletRequest request, HttpServletResponse response, BindException e) {
        this.LOG.debug("handleValidExceptionHandler");
        StringBuilder message = new StringBuilder();
        List fieldErrors = e.getBindingResult().getFieldErrors();
        for (FieldError error : fieldErrors) {
            message.append(error.getField()).append(error.getDefaultMessage()).append(",");
        }
        message = new StringBuilder(message.substring(0, message.length() - 1));
        return this.render(request, response, ResultData.build().code(HttpStatus.NOT_ACCEPTABLE).msg(message.toString()), (Exception)e);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ModelAndView handleUnauthorizedException(HttpServletRequest request, HttpServletResponse response, UnauthorizedException e) {
        this.LOG.debug("handleUnauthorizedException");
        return this.render(request, response, ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("\u65e0\u8bbf\u95ee\u6743\u9650!"), (Exception)e);
    }

    @ExceptionHandler(value={LockedAccountException.class})
    public ModelAndView handleLockedAccountException(HttpServletRequest request, HttpServletResponse response, LockedAccountException e) {
        this.LOG.debug("handleLockedAccountException");
        response.setStatus(HttpStatus.LOCKED.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.LOCKED).msg(e.getMessage()), (Exception)e);
    }

    @ExceptionHandler(value={IncorrectCredentialsException.class})
    public ModelAndView handleIncorrectCredentialsException(HttpServletRequest request, HttpServletResponse response, IncorrectCredentialsException e) {
        this.LOG.debug("IncorrectCredentialsException");
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg("\u7ba1\u7406\u5458\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef"), (Exception)e);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public ModelAndView handleAuthenticationException(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) {
        this.LOG.debug("AuthenticationException");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("AuthenticationException"), (Exception)e);
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public ModelAndView handleAuthorizationException(HttpServletRequest request, HttpServletResponse response, AuthorizationException e) {
        this.LOG.debug("AuthorizationException");
        return this.render(request, response, ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("AuthorizationException"), (Exception)e);
    }

    @ExceptionHandler(value={CredentialsException.class})
    public ModelAndView handleCredentialsException(HttpServletRequest request, HttpServletResponse response, CredentialsException e) {
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.UNAUTHORIZED).msg("CredentialsException"), (Exception)e);
    }

    @ExceptionHandler(value={ExpiredSessionException.class})
    public ModelAndView handleExpiredSessionException(HttpServletRequest request, HttpServletResponse response, ExpiredSessionException e) {
        this.LOG.debug("ExpiredSessionException", (Throwable)e);
        response.setStatus(HttpStatus.GATEWAY_TIMEOUT.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.GATEWAY_TIMEOUT), (Exception)e);
    }

    @ExceptionHandler(value={SQLException.class})
    public ModelAndView handleSQLException(HttpServletRequest request, HttpServletResponse response, SQLException e) {
        this.LOG.debug("SQLException", (Throwable)e);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.render(request, response, ResultData.build().code(HttpStatus.INTERNAL_SERVER_ERROR).msg("SQL\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"), e);
    }

    private ModelAndView render(HttpServletRequest request, HttpServletResponse response, ResultData resultData, Exception e) {
        this.LOG.debug("url: {}", (Object)request.getRequestURI());
        e.printStackTrace();
        String contextPath = request.getServletContext().getContextPath();
        request.setAttribute("base", (Object)contextPath);
        request.setAttribute("params", (Object)BasicUtil.assemblyRequestUrlParams());
        if (BasicUtil.isAjaxRequest(request)) {
            try {
                response.setContentType("application/json;charset=UTF-8");
                PrintWriter writer = response.getWriter();
                writer.write(JSONObject.toJSONString((Object)resultData));
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            return new ModelAndView("/error/index", (Map)resultData);
        }
        return null;
    }
}

