/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest request = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private static final Whitelist whitelist = new Whitelist();
    private static final Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public ServletInputStream getInputStream() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)this.request.getInputStream()));
        String line = null;
        StringBuffer result = new StringBuffer();
        while ((line = br.readLine()) != null) {
            result.append(line);
        }
        return new WrappedServletInputStream(new ByteArrayInputStream(this.clean(result.toString()).getBytes()));
    }

    public String getParameter(String name) {
        if ("content".equals(name) || name.endsWith("WithHtml")) {
            return super.getParameter(name);
        }
        String value = super.getParameter(name = this.clean(name));
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = this.clean(value);
        }
        return value;
    }

    public Map getParameterMap() {
        Map map = super.getParameterMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator entries = map.entrySet().iterator();
        String name = "";
        String value = "";
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            name = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (null == valueObj) {
                value = "";
            } else if (valueObj instanceof String[]) {
                String[] values = (String[])valueObj;
                for (int i = 0; i < values.length; ++i) {
                    value = values[i] + ",";
                }
                value = value.substring(0, value.length() - 1);
            } else {
                value = valueObj.toString();
            }
            returnMap.put(name, this.clean(name, value).trim());
        }
        return returnMap;
    }

    public String[] getParameterValues(String name) {
        String[] arr = super.getParameterValues(name);
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.clean(arr[i]);
            }
        }
        return arr;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name = this.clean(name));
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = this.clean(value);
        }
        return value;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getRequest();
        }
        return req;
    }

    public String clean(String content) {
        String result = Jsoup.clean((String)content, (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings);
        if (!content.equals(result = Parser.unescapeEntities((String)result, (boolean)true))) {
            String uri = SpringUtil.getRequest().getRequestURI();
            LOGGER.error("\u63a5\u53e3{}\u7684\u53c2\u6570\u4e0d\u7b26\u5408XSS\u89c4\u5219{}", (Object)uri, (Object)content);
            throw new BusinessException("\u53c2\u6570\u5f02\u5e38,url:" + uri);
        }
        return content;
    }

    public String clean(String name, String content) {
        String result = Jsoup.clean((String)content, (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings);
        if (!content.equals(result = Parser.unescapeEntities((String)result, (boolean)true)) || !SqlInjectionUtil.isSqlValid((String)content)) {
            String uri = SpringUtil.getRequest().getRequestURI();
            LOGGER.error("\u63a5\u53e3\u4e0d\u7b26\u5408XSS\u89c4\u5219:{}", (Object)uri);
            LOGGER.error("\u53c2\u6570\u540d:{} \u53c2\u6570\u503c:{}", (Object)name, (Object)content);
            throw new BusinessException("\u53c2\u6570\u5f02\u5e38,url:" + uri);
        }
        return content;
    }

    private class WrappedServletInputStream
    extends ServletInputStream {
        private InputStream stream;

        public void setStream(InputStream stream) {
            this.stream = stream;
        }

        public WrappedServletInputStream(InputStream stream) {
            this.stream = stream;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

