/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import cn.hutool.core.net.URLDecoder;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.UrlEncoderUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsoupUtil.class);
    private static final Whitelist WHITE_LIST = Whitelist.relaxed().preserveRelativeLinks(true);
    private static final Document.OutputSettings OUTPUT_SETTINGS = new Document.OutputSettings().prettyPrint(false);
    private static final String[] UNICODE_STR = new String[]{"+/v8", "+/v9", "+/v+", "+/v/"};
    private static final Pattern[] scriptPatterns = new Pattern[]{Pattern.compile("<script>(.*?)</script>", 2), Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42), Pattern.compile("</script>", 2), Pattern.compile("<script(.*?)>", 42), Pattern.compile("eval\\((.*?)\\)", 42), Pattern.compile("expression\\((.*?)\\)", 42), Pattern.compile("javascript:", 2), Pattern.compile("vbscript:", 2), Pattern.compile("onload(.*?)=", 42), Pattern.compile("onerror(.*?)=", 42), Pattern.compile("::\\$DATA", 42)};

    public static boolean hasXSS(String content) {
        String encode;
        if (UrlEncoderUtils.hasUrlEncoded(content) && StrUtil.containsAny((CharSequence)(encode = URLDecoder.decode((String)content, (Charset)StandardCharsets.UTF_8)), (CharSequence[])UNICODE_STR)) {
            return true;
        }
        String temp = content;
        for (Pattern pattern : scriptPatterns) {
            temp = pattern.matcher(temp).replaceAll("");
        }
        return !temp.equals(content);
    }

    public static String clean(String content) {
        if (JsoupUtil.hasXSS(content)) {
            LOGGER.error("xss content:{}", (Object)content);
            throw new BusinessException("\u5f53\u524d\u8bf7\u6c42\u5b58\u5728xss\u653b\u51fb\uff0c\u6709\u95ee\u9898\u7684\u5185\u5bb9\uff1a".concat(content));
        }
        return Jsoup.clean((String)content, (String)"", (Whitelist)WHITE_LIST, (Document.OutputSettings)OUTPUT_SETTINGS);
    }

    public static String cleanOrSqlInjection(String content) {
        if (JsoupUtil.hasXSS(content)) {
            LOGGER.error("xss content:{}", (Object)content);
            throw new BusinessException("\u5f53\u524d\u8bf7\u6c42\u5b58\u5728xss\u653b\u51fb\uff0c\u6709\u95ee\u9898\u7684\u5185\u5bb9\uff1a".concat(content));
        }
        SqlInjectionUtil.filterContent((String[])new String[]{content});
        return content;
    }

    static {
        WHITE_LIST.addAttributes(":all", new String[]{"style", "id", "class", "height", "width", "src"}).addAttributes("video", new String[]{"data-setup"});
    }
}

