/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.mingsoft.basic.util.SpringUtil;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;

public class RedisUtil {
    private static RedisTemplate redis;

    private static RedisTemplate getRedisTemplate() {
        if (redis == null) {
            redis = (RedisTemplate)SpringUtil.getBean(StringRedisTemplate.class);
        }
        return redis;
    }

    public static boolean hasKey(String key) {
        return RedisUtil.getRedisTemplate().hasKey((Object)key);
    }

    public static void delete(String key) {
        RedisUtil.getRedisTemplate().delete((Object)key);
    }

    public static boolean hasKey(String key, String hashKey) {
        return RedisUtil.getRedisTemplate().opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    public static void expire(String key, long timeout, TimeUnit unit) {
        RedisUtil.getRedisTemplate().expire((Object)key, timeout, unit);
    }

    public static long ttl(String key) {
        return RedisUtil.getRedisTemplate().getExpire((Object)key);
    }

    public static Set<String> keys(String pattern) {
        return RedisUtil.getRedisTemplate().keys((Object)pattern);
    }

    public static void delete(Set<String> keys) {
        RedisUtil.getRedisTemplate().delete(keys);
    }

    private static void setExpire(String key, long expire) {
        if (expire != -1L) {
            RedisUtil.getRedisTemplate().expire((Object)key, expire, TimeUnit.SECONDS);
        }
    }

    private static ValueOperations getValueOperations() {
        return RedisUtil.getRedisTemplate().opsForValue();
    }

    public static void addValue(String key, Object value, long expire) {
        RedisUtil.getValueOperations().set((Object)key, value);
        RedisUtil.setExpire(key, expire);
    }

    public static void addValue(String key, Object value, long expire, TimeUnit timeUnit) {
        RedisUtil.getValueOperations().set((Object)key, value, expire, timeUnit);
    }

    public static void addValue(String key, Object value) {
        RedisUtil.getValueOperations().set((Object)key, value);
    }

    public static Object getValue(String key) {
        return RedisUtil.getValueOperations().get((Object)key);
    }

    public static String get(String key) {
        Object obj = RedisUtil.getValueOperations().get((Object)key);
        return obj == null ? null : obj.toString();
    }

    private static HashOperations getHashOperations() {
        return RedisUtil.getRedisTemplate().opsForHash();
    }

    public static void addHashValue(String key, String hashKey, Object data, long expire) {
        RedisUtil.getHashOperations().put((Object)key, (Object)hashKey, data);
        RedisUtil.setExpire(key, expire);
    }

    public static void addAllHashValue(String key, Map<String, Object> map, long expire) {
        RedisUtil.getHashOperations().putAll((Object)key, map);
        RedisUtil.setExpire(key, expire);
    }

    public static long deleteHashValue(String key, String hashKey) {
        return RedisUtil.getHashOperations().delete((Object)key, new Object[]{hashKey});
    }

    public static Object getHashValue(String key, String hashKey) {
        return RedisUtil.getHashOperations().get((Object)key, (Object)hashKey);
    }

    public static List<Object> getHashAllValue(String key) {
        return RedisUtil.getHashOperations().values((Object)key);
    }

    public static List<Object> getHashMultiValue(String key, List<String> hashKeys) {
        return RedisUtil.getHashOperations().multiGet((Object)key, hashKeys);
    }

    public static Long getHashCount(String key) {
        return RedisUtil.getHashOperations().size((Object)key);
    }

    private static ZSetOperations getZSetOperations() {
        return RedisUtil.getRedisTemplate().opsForZSet();
    }

    public static boolean addZSetValue(String key, Object member, long score) {
        return RedisUtil.getZSetOperations().add((Object)key, member, (double)score);
    }

    public static boolean addZSetValue(String key, Object member, double score) {
        return RedisUtil.getZSetOperations().add((Object)key, member, score);
    }

    public static long addBatchZSetValue(String key, Set<ZSetOperations.TypedTuple<Object>> tuples) {
        return RedisUtil.getZSetOperations().add((Object)key, tuples);
    }

    public static void incZSetValue(String key, String member, long delta) {
        RedisUtil.getZSetOperations().incrementScore((Object)key, (Object)member, (double)delta);
    }

    public static long getZSetScore(String key, String member) {
        Double score = RedisUtil.getZSetOperations().score((Object)key, (Object)member);
        if (score == null) {
            return 0L;
        }
        return score.longValue();
    }

    public static Set<ZSetOperations.TypedTuple<Object>> getZSetRank(String key, long start, long end) {
        return RedisUtil.getZSetOperations().rangeWithScores((Object)key, start, end);
    }

    private static ListOperations getListOperations() {
        return RedisUtil.getRedisTemplate().opsForList();
    }

    public static void addListValue(String key, Object list) {
        RedisUtil.getListOperations().leftPush((Object)key, list);
    }

    public static Object getListValue(String key) {
        return RedisUtil.getListOperations().leftPop((Object)key);
    }

    private static SetOperations getSetOperations() {
        return RedisUtil.getRedisTemplate().opsForSet();
    }

    public static void addSetValue(String key, Object list) {
        RedisUtil.getSetOperations().add((Object)key, new Object[]{list});
    }

    public static Object getSetValue(String key) {
        return RedisUtil.getSetOperations().members((Object)key);
    }

    public static Object popSetValue(String key) {
        return RedisUtil.getSetOperations().pop((Object)key);
    }
}

