/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.CityBean;
import net.mingsoft.basic.biz.ICityBiz;
import net.mingsoft.basic.entity.CityEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u524d\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller(value="webCityAction")
@RequestMapping(value={"/basic/city"})
public class CityAction
extends BaseAction {
    @Autowired
    private ICityBiz cityBiz;

    @ApiOperation(value="\u67e5\u8be2\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="provinceName", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="cityName", value="\u5e02\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityPy", value="\u57ce\u5e02\u62fc\u97f3\u9996\u5b57\u6bcd", required=false, paramType="query"), @ApiImplicitParam(name="countyId", value="\u53bf\uff0f\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="countyName", value="\u53bf\uff0f\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="townId", value="\u8857\u9053\uff0f\u9547\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="townName", value="\u8857\u9053\uff0f\u9547\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="villageId", value="\u6751\u59d4\u4f1aid", required=false, paramType="query"), @ApiImplicitParam(name="villageName", value="\u6751\u59d4\u4f1a\u540d\u79f0", required=false, paramType="query")})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        BasicUtil.startPage();
        List cityList = this.cityBiz.query(city);
        BasicUtil.endPage(cityList);
        return ResultData.build().success((Object)cityList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e")
    @ApiImplicitParam(name="id", value="\u57ce\u5e02\u4e3b\u952e\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)city.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
        }
        CityEntity _city = (CityEntity)this.cityBiz.getEntity(Integer.parseInt(city.getId()));
        return ResultData.build().success((Object)_city);
    }

    @ApiOperation(value="\u83b7\u53d6\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u6811\u5f62\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="level", value="\u7701\u5e02\u53bf\u5c42\u7ea7\uff0c\u9ed8\u8ba4\u4e3a3", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="type", value="\u7ed3\u6784\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4e3atree", required=false, paramType="query")})
    @GetMapping(value={"/query"})
    @ResponseBody
    public ResultData query(HttpServletResponse response, HttpServletRequest request) {
        int level = BasicUtil.getInt("level", 3);
        String type = BasicUtil.getString("type", "tree");
        List<CityBean> cityList = this.cityBiz.queryForTree(level, type);
        return ResultData.build().success(cityList);
    }
}

