/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.filter;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.filter.XssHttpServletRequestWrapper;
import net.mingsoft.basic.filter.XssStringJsonSerializer;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.AntPathMatcher;

public class XSSEscapeFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSSEscapeFilter.class);
    private static boolean IS_INCLUDE_RICH_TEXT = false;
    public List<String> includes = new ArrayList<String>();
    public List<String> excludes = new ArrayList<String>();
    public static List<String> excludesFiled = new ArrayList<String>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.handleExcludeURL(req, resp)) {
            filterChain.doFilter(request, response);
            return;
        }
        if (!this.handleIncludeURL(req, resp)) {
            filterChain.doFilter(request, response);
            return;
        }
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request, excludesFiled);
        filterChain.doFilter((ServletRequest)xssRequest, response);
    }

    private boolean handleIncludeURL(HttpServletRequest request, HttpServletResponse response) {
        if (this.includes == null || this.includes.isEmpty()) {
            return false;
        }
        String url = request.getServletPath();
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String pattern : this.includes) {
            if (!antPathMatcher.match(pattern, url)) continue;
            return true;
        }
        return false;
    }

    private boolean handleExcludeURL(HttpServletRequest request, HttpServletResponse response) {
        if (this.excludes == null || this.excludes.isEmpty()) {
            return false;
        }
        String url = request.getServletPath();
        String params = request.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)params)) {
            url = url + "?" + params;
        }
        AntPathMatcher antPathMatcher = new AntPathMatcher();
        for (String pattern : this.excludes) {
            if (!antPathMatcher.match(pattern, url)) continue;
            return true;
        }
        return false;
    }

    @Bean
    @Primary
    public ObjectMapper xssObjectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        SimpleModule xssModule = new SimpleModule("XssStringJsonSerializer");
        xssModule.addSerializer((JsonSerializer)new XssStringJsonSerializer());
        objectMapper.registerModule((Module)xssModule);
        return objectMapper;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String temp;
        String isIncludeRichText;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xss filter init");
        }
        if (StringUtils.isNotBlank((CharSequence)(isIncludeRichText = filterConfig.getInitParameter("isIncludeRichText")))) {
            IS_INCLUDE_RICH_TEXT = BooleanUtils.toBoolean((String)isIncludeRichText);
        }
        if ((temp = filterConfig.getInitParameter("excludes")) != null) {
            String[] url = temp.split(",");
            for (int i = 0; url != null && i < url.length; ++i) {
                this.includes.add(url[i]);
            }
        }
    }

    public void destroy() {
    }
}

