/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.resolver;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.LocaleResolver;

public class MSLocaleResolver
implements LocaleResolver {
    private static final String I18N_LANGUAGE = "lang";
    private static final String I18N_LANGUAGE_SESSION = "i18n_language_session";

    public Locale resolveLocale(HttpServletRequest req) {
        String lang = req.getParameter(I18N_LANGUAGE);
        Locale locale = Locale.getDefault();
        if (!StringUtils.isEmpty((CharSequence)lang)) {
            String[] language = lang.split("_");
            locale = new Locale(language[0], language[1]);
            HttpSession session = req.getSession();
            session.setAttribute(I18N_LANGUAGE_SESSION, (Object)locale);
        } else {
            HttpSession session = req.getSession();
            Locale localeInSession = (Locale)session.getAttribute(I18N_LANGUAGE_SESSION);
            locale = localeInSession != null ? localeInSession : Locale.SIMPLIFIED_CHINESE;
        }
        return locale;
    }

    public void setLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
    }
}

