/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.exception;

import cn.hutool.core.bean.BeanUtil;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class ErrorController
extends BasicErrorController {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes, new ErrorProperties());
    }

    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = this.getStatus(request);
        Map model = Collections.unmodifiableMap(this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.TEXT_HTML)));
        response.setStatus(status.value());
        ModelAndView modelAndView = this.resolveErrorView(request, response, status, model);
        this.LOG.debug("errorhtml log meseeage\uff1a{},url\uff1a{}", (Object)model.get("status").toString(), model.get("path"));
        return modelAndView != null ? modelAndView : new ModelAndView("/error/index", (Map)ResultData.build().code(model.get("status").toString()).msg(model.get("message").toString()));
    }

    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        if (status == HttpStatus.NO_CONTENT) {
            return new ResponseEntity(status);
        }
        Map body = this.getErrorAttributes(request, this.isIncludeStackTrace(request, MediaType.ALL));
        this.LOG.debug("error status {}, error {},url {}", new Object[]{status, body, request.getRequestURI()});
        BeanUtil.copyProperties((Object)ResultData.build().code(status).msg(body.get("message").toString()), (Object)body, (String[])new String[0]);
        return new ResponseEntity((Object)body, status);
    }
}

