/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.config;

import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.support.spring.stat.DruidStatInterceptor;
import javax.servlet.Filter;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.JdkRegexpMethodPointcut;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DruidConfig {
    @Bean
    @ConditionalOnProperty(prefix="spring", name={"datasource.druid.stat-view-servlet.enabled"}, havingValue="true")
    public FilterRegistrationBean druidStatFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "/static/*,*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid,/druid/*");
        filterRegistrationBean.addInitParameter("principalSessionName", "username");
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring", name={"datasource.druid.stat-view-servlet.enabled"}, havingValue="true")
    public DruidStatInterceptor druidStatInterceptor() {
        return new DruidStatInterceptor();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring", name={"datasource.druid.stat-view-servlet.enabled"}, havingValue="true")
    public JdkRegexpMethodPointcut druidStatPointcut() {
        JdkRegexpMethodPointcut druidStatPointcut = new JdkRegexpMethodPointcut();
        String patterns = "net.mingsoft.*.biz.*";
        druidStatPointcut.setPatterns(new String[]{patterns});
        return druidStatPointcut;
    }

    @Bean
    @ConditionalOnProperty(prefix="spring", name={"datasource.druid.stat-view-servlet.enabled"}, havingValue="true")
    public Advisor druidStatAdvisor() {
        return new DefaultPointcutAdvisor((Pointcut)this.druidStatPointcut(), (Advice)this.druidStatInterceptor());
    }

    static {
        System.setProperty("druid.mysql.usePingMethod", "false");
    }
}

