/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.entity.CategoryEntity;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5206\u7c7b\u63a5\u53e3")
@Controller(value="cmsCategoryAction")
@RequestMapping(value={"/${ms.manager.path}/cms/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/cms/category/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryTitle", value="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6240\u5c5e\u680f\u76ee", required=false, paramType="query"), @ApiImplicitParam(name="categoryType", value="\u680f\u76ee\u7ba1\u7406\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categorySort", value="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="categoryListUrl", value="\u5217\u8868\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryUrl", value="\u5185\u5bb9\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryKeyword", value="\u680f\u76ee\u7ba1\u7406\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="categoryDescrip", value="\u680f\u76ee\u7ba1\u7406\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="categoryImg", value="\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="categoryDiyUrl", value="\u81ea\u5b9a\u4e49\u94fe\u63a5", required=false, paramType="query"), @ApiImplicitParam(name="mdiyModelId", value="\u680f\u76ee\u7ba1\u7406\u7684\u5185\u5bb9\u6a21\u578bid", required=false, paramType="query"), @ApiImplicitParam(name="categoryDatetime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="categoryManagerId", value="\u53d1\u5e03\u7528\u6237id", required=false, paramType="query"), @ApiImplicitParam(name="appId", value="\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="dictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryFlag", value="\u680f\u76ee\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categoryPath", value="\u680f\u76ee\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @RequestMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
        category.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List categoryList = this.categoryBiz.query(category);
        return ResultData.build().success((Object)new EUListBean(categoryList, (int)BasicUtil.endPage((List)categoryList).getTotal()));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute CategoryEntity category, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (category.getId() != null) {
            BaseEntity categoryEntity = this.categoryBiz.getEntity(Integer.parseInt(category.getId()));
            model.addAttribute("categoryEntity", (Object)categoryEntity);
        }
        return "/cms/category/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (category.getId() == null) {
            return ResultData.build().error();
        }
        category.setAppId(BasicUtil.getAppId());
        CategoryEntity _category = (CategoryEntity)this.categoryBiz.getEntity(Integer.parseInt(category.getId()));
        return ResultData.build().success((Object)_category);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryTitle", value="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6240\u5c5e\u680f\u76ee", required=false, paramType="query"), @ApiImplicitParam(name="categoryType", value="\u680f\u76ee\u7ba1\u7406\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categorySort", value="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="categoryListUrl", value="\u5217\u8868\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryUrl", value="\u5185\u5bb9\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryKeyword", value="\u680f\u76ee\u7ba1\u7406\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="categoryDescrip", value="\u680f\u76ee\u7ba1\u7406\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="categoryImg", value="\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="categoryDiyUrl", value="\u81ea\u5b9a\u4e49\u94fe\u63a5", required=false, paramType="query"), @ApiImplicitParam(name="mdiyModelId", value="\u680f\u76ee\u7ba1\u7406\u7684\u5185\u5bb9\u6a21\u578bid", required=false, paramType="query"), @ApiImplicitParam(name="categoryDatetime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="categoryManagerId", value="\u53d1\u5e03\u7528\u6237id", required=false, paramType="query"), @ApiImplicitParam(name="appId", value="\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="dictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryFlag", value="\u680f\u76ee\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categoryPath", value="\u680f\u76ee\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @LogAnn(title="\u4fdd\u5b58\u5206\u7c7b", businessType=BusinessTypeEnum.INSERT)
    @RequiresPermissions(value={"cms:category:save"})
    public ResultData save(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((Object)category.getCategoryTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("category.title")}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryTitle() + ""), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.title"), "1", "100"}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryPath() + ""), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.path"), "1", "100"}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryParentId() + ""), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.parent.id"), "1", "100"}));
        }
        category.setAppId(BasicUtil.getAppId());
        this.categoryBiz.saveEntity(category);
        return ResultData.build().success((Object)category);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @LogAnn(title="\u5220\u9664\u5206\u7c7b", businessType=BusinessTypeEnum.DELETE)
    @RequiresPermissions(value={"cms:category:del"})
    public ResultData delete(@RequestBody List<CategoryEntity> categorys, HttpServletResponse response, HttpServletRequest request) {
        for (int i = 0; i < categorys.size(); ++i) {
            this.categoryBiz.delete(Integer.parseInt(categorys.get(i).getId()));
        }
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="categoryTitle", value="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6240\u5c5e\u680f\u76ee", required=false, paramType="query"), @ApiImplicitParam(name="categoryType", value="\u680f\u76ee\u7ba1\u7406\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categorySort", value="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="categoryListUrl", value="\u5217\u8868\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryUrl", value="\u5185\u5bb9\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryKeyword", value="\u680f\u76ee\u7ba1\u7406\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="categoryDescrip", value="\u680f\u76ee\u7ba1\u7406\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="categoryImg", value="\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="categoryDiyUrl", value="\u81ea\u5b9a\u4e49\u94fe\u63a5", required=false, paramType="query"), @ApiImplicitParam(name="mdiyModelId", value="\u680f\u76ee\u7ba1\u7406\u7684\u5185\u5bb9\u6a21\u578bid", required=false, paramType="query"), @ApiImplicitParam(name="categoryDatetime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="categoryManagerId", value="\u53d1\u5e03\u7528\u6237id", required=false, paramType="query"), @ApiImplicitParam(name="appId", value="\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="dictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryFlag", value="\u680f\u76ee\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categoryPath", value="\u680f\u76ee\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @LogAnn(title="\u66f4\u65b0\u5206\u7c7b", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"cms:category:update"})
    public ResultData update(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((Object)category.getCategoryTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("category.title")}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryTitle() + ""), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.title"), "1", "100"}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryPath() + ""), (int)0, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.path"), "1", "100"}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryParentId() + ""), (int)0, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.parent.id"), "1", "100"}));
        }
        CategoryEntity _category = new CategoryEntity();
        _category.setCategoryParentId(category.getId());
        _category.setAppId(BasicUtil.getAppId());
        List<CategoryEntity> categoryList = this.categoryBiz.queryChilds(_category);
        for (CategoryEntity item : categoryList) {
            if (!item.getId().equals(category.getCategoryId())) continue;
            return ResultData.build().error(this.getResString("cannot.select.child"));
        }
        category.setAppId(BasicUtil.getAppId());
        this.categoryBiz.updateEntity(category);
        return ResultData.build().success((Object)category);
    }
}

