/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.util.CmsParserUtil;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="cmsGenerater")
@RequestMapping(value={"/${ms.manager.path}/cms/generate"})
@Scope(value="request")
public class GeneraterAction
extends BaseAction {
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Value(value="${ms.manager.path}")
    private String managerPath;

    @RequestMapping(value={"/index"})
    public String index(HttpServletRequest request, ModelMap model) {
        return "/cms/generate/index";
    }

    @RequestMapping(value={"/generateIndex"})
    @RequiresPermissions(value={"cms:generate:index"})
    @ResponseBody
    public void generateIndex(HttpServletRequest request, HttpServletResponse response) {
        String tmpFileName = request.getParameter("url");
        String generateFileName = request.getParameter("position");
        if (!FileUtil.exist((String)ParserUtil.buildTempletPath())) {
            this.outJson(response, false, this.getResString("templet.file"));
        } else {
            try {
                CmsParserUtil.generate(tmpFileName, generateFileName);
                this.outJson(response, true);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.outJson(response, false);
            }
        }
    }

    @RequestMapping(value={"/{CategoryId}/genernateColumn"})
    @RequiresPermissions(value={"cms:generate:column"})
    @ResponseBody
    public void genernateColumn(HttpServletRequest request, HttpServletResponse response, @PathVariable int CategoryId) {
        CategoryEntity categoryEntity;
        AppEntity app = BasicUtil.getApp();
        List<Object> columns = new ArrayList();
        if (CategoryId > 0) {
            categoryEntity = new CategoryEntity();
            categoryEntity.setId(CategoryId + "");
            categoryEntity.setAppId(app.getAppId());
            columns = this.categoryBiz.queryChilds(categoryEntity);
        } else {
            categoryEntity = new CategoryEntity();
            categoryEntity.setAppId(app.getAppId());
            columns = this.categoryBiz.query(categoryEntity);
        }
        List<ContentBean> articleIdList = null;
        try {
            for (CategoryEntity column : columns) {
                if (!FileUtil.exist((String)ParserUtil.buildTempletPath((String)column.getCategoryUrl()))) continue;
                articleIdList = this.contentBiz.queryIdsByCategoryIdForParser(column.getId(), null, null);
                switch (column.getCategoryType()) {
                    case "1": {
                        CmsParserUtil.generateList(column, articleIdList.size());
                        break;
                    }
                    case "2": {
                        if (articleIdList.size() == 0) {
                            ContentBean columnArticleIdBean = new ContentBean();
                            CopyOptions copyOptions = CopyOptions.create();
                            copyOptions.setIgnoreError(true);
                            BeanUtil.copyProperties((Object)((Object)column), (Object)((Object)columnArticleIdBean), (CopyOptions)copyOptions);
                            articleIdList.add(columnArticleIdBean);
                        }
                        CmsParserUtil.generateBasic(articleIdList);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.outJson(response, false);
        }
        this.outJson(response, true);
    }

    @RequestMapping(value={"/{columnId}/generateArticle"})
    @RequiresPermissions(value={"cms:generate:article"})
    @ResponseBody
    public void generateArticle(HttpServletRequest request, HttpServletResponse response, @PathVariable String columnId) {
        String dateTime = request.getParameter("dateTime");
        List<ContentBean> articleIdList = null;
        try {
            articleIdList = this.contentBiz.queryIdsByCategoryIdForParser(columnId, dateTime, null);
            if (articleIdList.size() > 0) {
                CmsParserUtil.generateBasic(articleIdList);
            }
            this.outJson(response, true);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.outJson(response, false);
        }
    }

    @RequestMapping(value={"/{position}/viewIndex"})
    public String viewIndex(HttpServletRequest request, @PathVariable String position, HttpServletResponse response) {
        AppEntity app = BasicUtil.getApp();
        String indexPosition = app.getAppHostUrl() + File.separator + "html" + File.separator + app.getAppId() + File.separator + position + ".html";
        return "redirect:" + indexPosition;
    }
}

