/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.biz.impl;

import cn.hutool.core.util.ObjectUtil;
import java.util.List;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.dao.ICategoryDao;
import net.mingsoft.cms.entity.CategoryEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cmscategoryBizImpl")
public class CategoryBizImpl
extends BaseBizImpl
implements ICategoryBiz {
    @Autowired
    private ICategoryDao categoryDao;

    protected IBaseDao getDao() {
        return this.categoryDao;
    }

    @Override
    public List<CategoryEntity> queryChilds(CategoryEntity category) {
        return this.categoryDao.queryChildren(category);
    }

    @Override
    public void saveEntity(CategoryEntity categoryEntity) {
        String path;
        this.setParentId(categoryEntity);
        super.saveEntity((BaseEntity)categoryEntity);
        String string = path = ObjectUtil.isNotNull((Object)categoryEntity.getCategoryParentId()) ? categoryEntity.getCategoryParentId() : "";
        if (StringUtils.isNotBlank((CharSequence)path)) {
            categoryEntity.setCategoryPath("/" + path.replaceAll(",", "/") + "/" + categoryEntity.getId());
        } else {
            categoryEntity.setCategoryPath("/" + categoryEntity.getId());
        }
        super.updateEntity((BaseEntity)categoryEntity);
    }

    private void setParentId(CategoryEntity categoryEntity) {
        if (StringUtils.isNotEmpty((CharSequence)categoryEntity.getCategoryId()) && Integer.parseInt(categoryEntity.getCategoryId()) > 0) {
            CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(Integer.parseInt(categoryEntity.getCategoryId()));
            if (StringUtils.isEmpty((CharSequence)category.getCategoryParentId())) {
                categoryEntity.setCategoryParentId(category.getId());
            } else {
                categoryEntity.setCategoryParentId(category.getCategoryParentId() + "," + category.getId());
            }
        } else {
            categoryEntity.setCategoryParentId(null);
        }
        if (StringUtils.isNotBlank((CharSequence)categoryEntity.getId())) {
            String path;
            String string = path = ObjectUtil.isNotNull((Object)categoryEntity.getCategoryParentId()) ? categoryEntity.getCategoryParentId() : "";
            if (StringUtils.isNotBlank((CharSequence)path)) {
                categoryEntity.setCategoryPath("/" + path.replaceAll(",", "/") + "/" + categoryEntity.getId());
            } else {
                categoryEntity.setCategoryPath("/" + categoryEntity.getId());
            }
        }
    }

    private void setChildParentId(CategoryEntity categoryEntity) {
        CategoryEntity category = new CategoryEntity();
        category.setCategoryId(categoryEntity.getId());
        List list = this.categoryDao.query(category);
        list.forEach(x -> {
            String path;
            if (StringUtils.isEmpty((CharSequence)categoryEntity.getCategoryParentId())) {
                x.setCategoryParentId(categoryEntity.getId());
            } else {
                x.setCategoryParentId(categoryEntity.getCategoryParentId() + "," + categoryEntity.getId());
            }
            String string = path = ObjectUtil.isNotNull((Object)x.getCategoryParentId()) ? x.getCategoryParentId() : "";
            if (StringUtils.isNotBlank((CharSequence)path)) {
                x.setCategoryPath("/" + path.replaceAll(",", "/") + "/" + x.getId());
            } else {
                x.setCategoryPath("/" + x.getId());
            }
            super.updateEntity((BaseEntity)x);
            this.setChildParentId((CategoryEntity)((Object)x));
        });
    }

    @Override
    public void updateEntity(CategoryEntity entity) {
        this.setParentId(entity);
        super.updateEntity((BaseEntity)entity);
        this.setChildParentId(entity);
    }

    @Override
    public void delete(int categoryId) {
        CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(categoryId);
        if (category != null) {
            category.setCategoryParentId(null);
            List<CategoryEntity> childrenList = this.categoryDao.queryChildren(category);
            int[] ids = new int[childrenList.size()];
            for (int i = 0; i < childrenList.size(); ++i) {
                ids[i] = Integer.parseInt(childrenList.get(i).getId());
            }
            this.categoryDao.delete(ids);
            this.deleteEntity(categoryId);
        }
    }
}

