/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action.web;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.cms.util.CmsParserUtil;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.IPageBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.parser.TagParser;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="dynamicPageAction")
@RequestMapping(value={"/mcms"})
public class MCmsAction
extends BaseAction {
    @Autowired
    private IPageBiz pageBiz;
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    public static final String SEARCH = "search";
    @Autowired
    private IModelBiz modelBiz;

    @GetMapping(value={"/index.do"})
    public void index(HttpServletRequest req, HttpServletResponse resp) {
        Map map = BasicUtil.assemblyRequestMap();
        map.put("url", BasicUtil.getUrl());
        map.put("isDo", true);
        map.put("modelName", "mcms");
        String content = "";
        try {
            content = CmsParserUtil.generate((String)"index.htm", (Map)map, (boolean)this.isMobileDevice(req));
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.outString(resp, content);
    }

    @GetMapping(value={"/list.do"})
    public void list(HttpServletRequest req, HttpServletResponse resp) {
        Map map = BasicUtil.assemblyRequestMap();
        int typeId = BasicUtil.getInt((String)"typeid", (int)0);
        int size = BasicUtil.getInt((String)"size", (int)10);
        List<ContentBean> columnArticles = this.contentBiz.queryIdsByCategoryIdForParser(String.valueOf(typeId), null, null);
        if (columnArticles.size() == 0) {
            this.outJson(resp, false);
        }
        PageBean page = new PageBean();
        int total = PageUtil.totalPage((int)columnArticles.size(), (int)size);
        map.put("column", columnArticles.get(0));
        page.setTotal(total);
        map.put("typeid", typeId);
        map.put("pageNo", BasicUtil.getInt((String)"pageNo", (int)1));
        map.put("url", BasicUtil.getUrl());
        map.put("pageTag", page);
        map.put("isDo", true);
        map.put("modelName", "mcms");
        String content = "";
        try {
            content = CmsParserUtil.generate((String)columnArticles.get(0).getCategoryListUrl(), (Map)map, (boolean)this.isMobileDevice(req));
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.outString(resp, content);
    }

    @GetMapping(value={"/view.do"})
    public void view(String orderby, String order, HttpServletRequest req, HttpServletResponse resp) {
        ContentEntity article = (ContentEntity)this.contentBiz.getEntity(BasicUtil.getInt((String)"id"));
        if (ObjectUtil.isNull((Object)((Object)article))) {
            this.outJson(resp, null, false, this.getResString("err.empty", new String[]{this.getResString("id")}));
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)order) && !order.toLowerCase().equals("asc") && !order.toLowerCase().equals("desc")) {
            this.outJson(resp, null, false, this.getResString("err.error", new String[]{this.getResString("order")}));
            return;
        }
        PageBean page = new PageBean();
        CategoryEntity column = (CategoryEntity)this.categoryBiz.getEntity(Integer.parseInt(article.getContentCategoryId()));
        String content = "";
        Map map = BasicUtil.assemblyRequestMap();
        map.put("isDo", true);
        map.put("modelName", "mcms");
        map.put("url", BasicUtil.getUrl());
        map.put("pageTag", page);
        map.put("id", article.getId());
        List<ContentBean> articleIdList = this.contentBiz.queryIdsByCategoryIdForParser(column.getCategoryId(), null, null, orderby, order);
        HashMap<String, String> contentModelMap = new HashMap<String, String>();
        ModelEntity contentModel = null;
        for (int artId = 0; artId < articleIdList.size(); ++artId) {
            ContentBean nextCaBean;
            ContentBean preCaBean;
            if (articleIdList.get(artId).getArticleId() != Integer.parseInt(article.getId())) {
                continue;
            }
            String articleColumnPath = articleIdList.get(artId).getCategoryPath();
            String columnContentModelId = articleIdList.get(artId).getMdiyModelId();
            HashMap<String, Object> parserParams = new HashMap<String, Object>();
            parserParams.put("column", (Object)articleIdList.get(artId));
            if (StringUtils.isNotBlank((CharSequence)columnContentModelId)) {
                if (contentModelMap.containsKey(columnContentModelId)) {
                    parserParams.put("tableName", contentModel.getModelTableName());
                } else {
                    contentModel = (ModelEntity)this.modelBiz.getEntity(Integer.parseInt(columnContentModelId));
                    contentModelMap.put(columnContentModelId, contentModel.getModelTableName());
                    parserParams.put("tableName", contentModel.getModelTableName());
                }
            }
            if (artId > 0 && articleColumnPath.contains((preCaBean = articleIdList.get(artId - 1)).getCategoryId() + "")) {
                page.setPreId(preCaBean.getArticleId());
            }
            if (artId + 1 >= articleIdList.size() || !articleColumnPath.contains((nextCaBean = articleIdList.get(artId + 1)).getCategoryId() + "")) break;
            page.setNextId(nextCaBean.getArticleId());
            break;
        }
        try {
            content = CmsParserUtil.generate((String)column.getCategoryUrl(), (Map)map, (boolean)this.isMobileDevice(req));
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.outString(resp, content);
    }

    @RequestMapping(value={"search"})
    @ResponseBody
    public void search(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map field = BasicUtil.assemblyRequestMap();
        HashMap diyFieldName = new HashMap();
        CategoryEntity column = null;
        ModelEntity contentModel = null;
        ArrayList<DiyModelMap> fieldValueList = new ArrayList<DiyModelMap>();
        int typeId = 0;
        String categoryIds = BasicUtil.getString((String)"categoryId");
        if (!StringUtil.isBlank((Object)categoryIds) && !categoryIds.contains(",")) {
            typeId = Integer.parseInt(categoryIds);
        }
        ArrayList filedStr = new ArrayList();
        if (typeId > 0) {
            column = (CategoryEntity)this.categoryBiz.getEntity(Integer.parseInt(typeId + ""));
            if (column != null && ObjectUtil.isNotNull((Object)column.getMdiyModelId()) && (contentModel = (ModelEntity)this.modelBiz.getEntity(Integer.parseInt(column.getMdiyModelId()))) != null) {
                Map fieldMap = contentModel.getFieldMap();
                for (String s : fieldMap.keySet()) {
                    filedStr.add(fieldMap.get(s));
                }
                map.put("tableName", contentModel.getModelTableName());
            }
            map.put("column", (Object)column);
        }
        if (field != null) {
            for (Map.Entry entry : field.entrySet()) {
                String value;
                if (entry == null || ObjectUtil.isNull((Object)(value = entry.getValue().toString()))) continue;
                if (request.getMethod().equals(RequestMethod.GET)) {
                    try {
                        value = new String(value.getBytes("ISO-8859-1"), "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (StringUtil.isBlank((Object)value)) continue;
                diyFieldName.put(entry.getKey(), value);
                if (!filedStr.contains(entry.getKey())) continue;
                DiyModelMap diyMap = new DiyModelMap();
                diyMap.setKey((String)entry.getKey());
                diyMap.setValue(value);
                fieldValueList.add(diyMap);
            }
        }
        if (fieldValueList.size() > 0) {
            map.put("diyModel", fieldValueList);
        }
        PageBean page = new PageBean();
        int size = BasicUtil.getInt((String)"size", (int)10);
        try {
            size = TagParser.getPageSize((String)ParserUtil.read((String)"search.htm", (boolean)false));
        }
        catch (TemplateNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (MalformedTemplateNameException e1) {
            e1.printStackTrace();
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Map searchMap = field;
        searchMap.forEach((k, v) -> {
            if (MCmsAction.sqlFilter(v.toString())) {
                searchMap.put(k, "");
            }
        });
        int count = this.contentBiz.getSearchCount(contentModel, fieldValueList, searchMap, BasicUtil.getAppId(), categoryIds);
        int total = PageUtil.totalPage((int)count, (int)size);
        int pageNo = BasicUtil.getInt((String)"pageNo", (int)1);
        if (pageNo >= total && total != 0) {
            pageNo = total;
        }
        page.setTotal(total);
        page.setSize(size);
        page.setPageNo(pageNo);
        String str = "pageNo,size";
        String url = BasicUtil.getUrl() + request.getServletPath() + "?" + BasicUtil.assemblyRequestUrlParams((String[])str.split(","));
        String pageNoStr = "&size=" + size + "&" + "pageNo" + "=";
        String nextUrl = url + pageNoStr + (pageNo + 1 > total ? total : pageNo + 1);
        String indexUrl = url + pageNoStr + 1;
        String lastUrl = url + pageNoStr + total;
        String preUrl = url + pageNoStr + (pageNo == 1 ? 1 : pageNo - 1);
        page.setIndexUrl(indexUrl);
        page.setNextUrl(nextUrl);
        page.setPreUrl(preUrl);
        page.setLastUrl(lastUrl);
        map.put("url", BasicUtil.getUrl());
        searchMap.put("pageNo", pageNo);
        map.put(SEARCH, searchMap);
        map.put("pageTag", page);
        map.put("isDo", false);
        map.put("modelName", "mcms");
        String content = "";
        try {
            content = CmsParserUtil.generate((String)"search.htm", map, (boolean)this.isMobileDevice(request));
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.outString(response, content);
    }

    public static boolean sqlFilter(String str) {
        Pattern pattern = Pattern.compile("\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|'|%)");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private Map get(String key, List<Map> fields) {
        for (Map field : fields) {
            if (!key.equals(field.get("key"))) continue;
            return field;
        }
        return null;
    }

    public class DiyModelMap {
        String key;
        Object value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

