/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.biz.impl;

import cn.hutool.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.List;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.dao.ICategoryDao;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.util.PinYinUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cmscategoryBizImpl")
public class CategoryBizImpl
extends BaseBizImpl
implements ICategoryBiz {
    @Autowired
    private ICategoryDao categoryDao;

    protected IBaseDao getDao() {
        return this.categoryDao;
    }

    @Override
    public List<CategoryEntity> queryChilds(CategoryEntity category) {
        return this.categoryDao.queryChildren(category);
    }

    @Override
    public void saveEntity(CategoryEntity categoryEntity) {
        CategoryEntity parentCategory;
        String pingYin = PinYinUtil.getPingYin(categoryEntity.getCategoryTitle());
        CategoryEntity category = new CategoryEntity();
        category.setCategoryPinyin(pingYin);
        category.setAppId(BasicUtil.getAppId());
        Serializable categoryBizEntity = this.getEntity(category);
        this.setParentId(categoryEntity);
        categoryEntity.setCategoryPinyin(pingYin);
        super.saveEntity((BaseEntity)categoryEntity);
        if (categoryBizEntity != null) {
            categoryEntity.setCategoryPinyin(pingYin + categoryEntity.getId());
        }
        String path = ObjectUtil.isNotNull((Object)((Object)(parentCategory = (CategoryEntity)this.categoryDao.getEntity(Integer.parseInt(categoryEntity.getCategoryId()))))) ? categoryEntity.getCategoryPath() : "";
        categoryEntity.setCategoryPath(path + "/" + categoryEntity.getCategoryPinyin());
        super.updateEntity((BaseEntity)categoryEntity);
    }

    private void setParentId(CategoryEntity categoryEntity) {
        String path = "";
        if (StringUtils.isNotEmpty((CharSequence)categoryEntity.getCategoryId()) && Integer.parseInt(categoryEntity.getCategoryId()) > 0) {
            CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(Integer.parseInt(categoryEntity.getCategoryId()));
            path = category.getCategoryPath();
            if (StringUtils.isEmpty((CharSequence)category.getCategoryParentId())) {
                categoryEntity.setCategoryParentId(category.getId());
            } else {
                categoryEntity.setCategoryParentId(category.getCategoryParentId() + "," + category.getId());
            }
        } else {
            categoryEntity.setCategoryParentId(null);
        }
        if (StringUtils.isNotBlank((CharSequence)categoryEntity.getId())) {
            categoryEntity.setCategoryPath(path + "/" + categoryEntity.getCategoryPinyin());
        }
    }

    private void setChildParentId(CategoryEntity categoryEntity) {
        CategoryEntity category = new CategoryEntity();
        category.setCategoryId(categoryEntity.getId());
        List list = this.categoryDao.query(category);
        list.forEach(x -> {
            if (StringUtils.isEmpty((CharSequence)categoryEntity.getCategoryParentId())) {
                x.setCategoryParentId(categoryEntity.getId());
            } else {
                x.setCategoryParentId(categoryEntity.getCategoryParentId() + "," + categoryEntity.getId());
            }
            String path = categoryEntity.getCategoryPath();
            x.setCategoryPath(path + "/" + x.getCategoryPinyin());
            super.updateEntity((BaseEntity)x);
            this.setChildParentId((CategoryEntity)((Object)x));
        });
    }

    @Override
    public void updateEntity(CategoryEntity entity) {
        this.setParentId(entity);
        String pingYin = PinYinUtil.getPingYin(entity.getCategoryTitle());
        CategoryEntity category = new CategoryEntity();
        category.setCategoryPinyin(pingYin);
        category.setAppId(BasicUtil.getAppId());
        CategoryEntity categoryBizEntity = (CategoryEntity)((Object)this.getEntity(category));
        if (categoryBizEntity != null && !categoryBizEntity.getId().equals(entity.getId())) {
            entity.setCategoryPinyin(pingYin + entity.getId());
        }
        super.updateEntity((BaseEntity)entity);
        this.setChildParentId(entity);
    }

    @Override
    public void delete(int categoryId) {
        CategoryEntity category = (CategoryEntity)this.categoryDao.getEntity(categoryId);
        if (category != null) {
            category.setCategoryParentId(null);
            List<CategoryEntity> childrenList = this.categoryDao.queryChildren(category);
            int[] ids = new int[childrenList.size()];
            for (int i = 0; i < childrenList.size(); ++i) {
                ids[i] = Integer.parseInt(childrenList.get(i).getId());
            }
            this.categoryDao.delete(ids);
            this.deleteEntity(categoryId);
        }
    }
}

