/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.PageUtil;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.impl.ModelBizImpl;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.parser.TagParser;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;

public class CmsParserUtil
extends ParserUtil {
    private static int COLUMN_TYPE_COVER = 2;

    public static void generate(String templatePath, String targetPath) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDo", false);
        CategoryEntity column = new CategoryEntity();
        map.put("column", (Object)column);
        String content = CmsParserUtil.generate((String)templatePath, map, (boolean)false);
        FileUtil.writeString((String)content, (String)ParserUtil.buildHtmlPath((String)targetPath), (String)"utf-8");
        if (ParserUtil.hasMobileFile((String)templatePath)) {
            map.put("m", BasicUtil.getApp().getAppMobileStyle());
            content = CmsParserUtil.generate((String)templatePath, map, (boolean)true);
            FileUtil.writeString((String)content, (String)ParserUtil.buildMobileHtmlPath((String)targetPath), (String)"utf-8");
        }
    }

    public static void generateList(CategoryEntity column, int articleIdTotal) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        if (ftl == null) {
            ftl = new FileTemplateLoader(new File(ParserUtil.buildTempletPath()));
            cfg.setTemplateLoader((TemplateLoader)ftl);
        }
        try {
            Template mobileTemplate = cfg.getTemplate(BasicUtil.getApp().getAppMobileStyle() + File.separator + column.getCategoryListUrl(), "utf-8");
            Template template = cfg.getTemplate(File.separator + column.getCategoryListUrl(), "utf-8");
            String columnContentModelId = column.getMdiyModelId();
            StringWriter writer = new StringWriter();
            try {
                template.process(null, (Writer)writer);
                String content = writer.toString();
                int pageSize = TagParser.getPageSize((String)content);
                int totalPageSize = PageUtil.totalPage((int)articleIdTotal, (int)pageSize);
                ModelEntity contentModel = null;
                if (StringUtils.isNotBlank((CharSequence)columnContentModelId)) {
                    contentModel = (ModelEntity)((ModelBizImpl)SpringUtil.getBean(ModelBizImpl.class)).getEntity(Integer.parseInt(columnContentModelId));
                }
                int pageNo = 1;
                PageBean page = new PageBean();
                page.setSize(pageSize);
                HashMap<String, Object> parserParams = new HashMap<String, Object>();
                parserParams.put("column", (Object)column);
                page.setTotal(totalPageSize);
                parserParams.put("isDo", false);
                parserParams.put("html", "html");
                parserParams.put("appId", BasicUtil.getAppId());
                if (contentModel != null) {
                    parserParams.put("tableName", contentModel.getModelTableName());
                }
                if (ParserUtil.IS_SINGLE) {
                    parserParams.put("url", BasicUtil.getUrl());
                }
                if (totalPageSize <= 0) {
                    String mobilePath = ParserUtil.buildMobileHtmlPath((String)(column.getCategoryPath() + File.separator + "index"));
                    String columnListPath = ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "index"));
                    page.setPageNo(pageNo);
                    parserParams.put("pageTag", page);
                    TagParser tag = new TagParser(content, parserParams);
                    FileUtil.writeString((String)tag.rendering(), (String)columnListPath, (String)"utf-8");
                    if (ParserUtil.hasMobileFile((String)column.getCategoryListUrl())) {
                        writer = new StringWriter();
                        mobileTemplate.process(null, (Writer)writer);
                        parserParams.put("m", BasicUtil.getApp().getAppMobileStyle());
                        tag = new TagParser(writer.toString(), parserParams);
                        FileUtil.writeString((String)tag.rendering(), (String)mobilePath, (String)"utf-8");
                    }
                    writer = new StringWriter();
                } else {
                    for (int i = 0; i < totalPageSize; ++i) {
                        String columnListPath;
                        String mobilePath;
                        if (i == 0) {
                            mobilePath = ParserUtil.buildMobileHtmlPath((String)(column.getCategoryPath() + File.separator + "index"));
                            columnListPath = ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "index"));
                        } else {
                            mobilePath = ParserUtil.buildMobileHtmlPath((String)(column.getCategoryPath() + File.separator + "list-" + pageNo));
                            columnListPath = ParserUtil.buildHtmlPath((String)(column.getCategoryPath() + File.separator + "list-" + pageNo));
                        }
                        page.setPageNo(pageNo);
                        parserParams.put("pageTag", page);
                        TagParser tag = new TagParser(content, parserParams);
                        FileUtil.writeString((String)tag.rendering(), (String)columnListPath, (String)"utf-8");
                        if (ParserUtil.hasMobileFile((String)column.getCategoryListUrl())) {
                            writer = new StringWriter();
                            mobileTemplate.process(null, (Writer)writer);
                            parserParams.put("m", BasicUtil.getApp().getAppMobileStyle());
                            tag = new TagParser(writer.toString(), parserParams);
                            FileUtil.writeString((String)tag.rendering(), (String)mobilePath, (String)"utf-8");
                        }
                        writer = new StringWriter();
                        ++pageNo;
                    }
                }
            }
            catch (TemplateException e) {
                e.printStackTrace();
            }
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void generateBasic(List<ContentBean> articleIdList) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        HashMap<String, String> contentModelMap = new HashMap<String, String>();
        ModelEntity contentModel = null;
        String writePath = null;
        ArrayList<Integer> generateIds = new ArrayList<Integer>();
        int artId = 0;
        while (artId < articleIdList.size()) {
            ContentBean nextCaBean;
            ContentBean preCaBean;
            PageBean page = new PageBean();
            int articleId = articleIdList.get(artId).getArticleId();
            String articleColumnPath = articleIdList.get(artId).getCategoryPath();
            String columnUrl = articleIdList.get(artId).getCategoryUrl();
            String columnContentModelId = "";
            if (StringUtils.isNotBlank((CharSequence)articleIdList.get(artId).getMdiyModelId()) && Integer.parseInt(articleIdList.get(artId).getMdiyModelId()) > 0) {
                columnContentModelId = articleIdList.get(artId).getMdiyModelId();
            }
            if (generateIds.contains(articleId)) {
                ++artId;
                continue;
            }
            if (!FileUtil.exist((String)ParserUtil.buildTempletPath((String)columnUrl)) || articleIdList.get(artId).getCategoryId() == null || articleIdList.get(artId).getCategoryType() == null) {
                ++artId;
                continue;
            }
            generateIds.add(articleId);
            writePath = ParserUtil.buildHtmlPath((String)(articleColumnPath + File.separator + articleId));
            if (Integer.parseInt(articleIdList.get(artId).getCategoryType()) == COLUMN_TYPE_COVER) {
                writePath = ParserUtil.buildHtmlPath((String)(articleColumnPath + File.separator + "index"));
            }
            HashMap<String, Object> parserParams = new HashMap<String, Object>();
            parserParams.put("column", (Object)articleIdList.get(artId));
            if (StringUtils.isNotBlank((CharSequence)columnContentModelId)) {
                if (contentModelMap.containsKey(columnContentModelId)) {
                    parserParams.put("tableName", contentModel.getModelTableName());
                } else {
                    contentModel = (ModelEntity)((IModelBiz)SpringUtil.getBean(IModelBiz.class)).getEntity(Integer.parseInt(columnContentModelId));
                    contentModelMap.put(columnContentModelId, contentModel.getModelTableName());
                    parserParams.put("tableName", contentModel.getModelTableName());
                }
            }
            parserParams.put("id", articleId);
            if (artId > 0 && articleColumnPath.contains((preCaBean = articleIdList.get(artId - 1)).getCategoryId() + "")) {
                page.setPreId(preCaBean.getArticleId());
            }
            if (artId + 1 < articleIdList.size() && articleColumnPath.contains((nextCaBean = articleIdList.get(artId + 1)).getCategoryId() + "")) {
                page.setNextId(nextCaBean.getArticleId());
            }
            parserParams.put("isDo", false);
            parserParams.put("pageTag", page);
            String content = CmsParserUtil.generate((String)articleIdList.get(artId).getCategoryUrl(), parserParams, (boolean)false);
            FileUtil.writeString((String)content, (String)writePath, (String)"utf-8");
            if (ParserUtil.hasMobileFile((String)columnUrl)) {
                writePath = ParserUtil.buildMobileHtmlPath((String)(articleColumnPath + File.separator + articleId));
                if (Integer.parseInt(articleIdList.get(artId).getCategoryType()) == COLUMN_TYPE_COVER) {
                    writePath = ParserUtil.buildMobileHtmlPath((String)(articleColumnPath + File.separator + "index"));
                }
                if (!FileUtil.exist((String)ParserUtil.buildTempletPath((String)("m" + File.separator + columnUrl)))) {
                    ++artId;
                    continue;
                }
                parserParams.put("m", BasicUtil.getApp().getAppMobileStyle());
                content = CmsParserUtil.generate((String)articleIdList.get(artId).getCategoryUrl(), parserParams, (boolean)true);
                FileUtil.writeString((String)content, (String)writePath, (String)"utf-8");
            }
            ++artId;
        }
    }
}

