/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.spring.stat.BeanTypeAutoProxyCreator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import net.mingsoft.basic.filter.XSSEscapeFilter;
import net.mingsoft.basic.interceptor.ActionInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    @Value(value="${ms.upload.path}")
    private String uploadFloderPath;
    @Value(value="${ms.upload.mapping}")
    private String uploadMapping;

    @Bean
    public ActionInterceptor actionInterceptor() {
        return new ActionInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.actionInterceptor()).excludePathPatterns(new String[]{"/static/**", "/app/**", "/webjars/**", "/*.html", "/*.htm"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"/upload/", "file:upload/"});
        registry.addResourceHandler(new String[]{"/templets/**"}).addResourceLocations(new String[]{"/templets/", "file:templets/"});
        registry.addResourceHandler(new String[]{"/html/**"}).addResourceLocations(new String[]{"/html/", "file:html/"});
        registry.addResourceHandler(new String[]{"/app/**"}).addResourceLocations(new String[]{"/app/", "file:app/", "classpath:/app/"});
        registry.addResourceHandler(new String[]{"/static/**", "/**"}).addResourceLocations(new String[]{"/static/", "file:static/", "classpath:/static/", "classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/api/**"}).addResourceLocations(new String[]{"/api/", "file:api/", "classpath:/api/"});
        if (new File(this.uploadFloderPath).isAbsolute()) {
            registry.addResourceHandler(new String[]{this.uploadMapping}).addResourceLocations(new String[]{"file:" + this.uploadFloderPath + File.separator});
        }
    }

    @Bean
    public BeanTypeAutoProxyCreator beanTypeAutoProxyCreator() {
        BeanTypeAutoProxyCreator beanTypeAutoProxyCreator = new BeanTypeAutoProxyCreator();
        beanTypeAutoProxyCreator.setTargetBeanType(DruidDataSource.class);
        beanTypeAutoProxyCreator.setInterceptorNames(new String[]{"druidStatInterceptor"});
        return beanTypeAutoProxyCreator;
    }

    @Bean
    public FilterRegistrationBean xssFilterRegistration() {
        XSSEscapeFilter xssFilter = new XSSEscapeFilter();
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)xssFilter, new ServletRegistrationBean[0]);
        xssFilter.includes.add(".*/search.do");
        registration.setName("XSSFilter");
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }

    @Bean
    public ServletListenerRegistrationBean<RequestContextListener> requestContextListenerRegistration() {
        return new ServletListenerRegistrationBean((EventListener)new RequestContextListener());
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/index");
        registry.setOrder(Integer.MIN_VALUE);
        super.addViewControllers(registry);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.mappingJackson2HttpMessageConverter());
        super.configureMessageConverters(converters);
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        converter.setObjectMapper(objectMapper);
        return converter;
    }
}

