/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.entity.ContentEntity;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6587\u7ae0\u63a5\u53e3")
@Controller(value="cmsContentAction")
@RequestMapping(value={"/${ms.manager.path}/cms/content"})
public class ContentAction
extends BaseAction {
    @Autowired
    private IContentBiz contentBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/cms/content/index";
    }

    @GetMapping(value={"/main"})
    public String main(HttpServletResponse response, HttpServletRequest request) {
        return "/cms/content/main";
    }

    @ApiOperation(value="\u67e5\u8be2\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="contentTitle", value="\u6587\u7ae0\u6807\u9898", required=false, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6240\u5c5e\u680f\u76ee", required=false, paramType="query"), @ApiImplicitParam(name="contentType", value="\u6587\u7ae0\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="contentDisplay", value="\u662f\u5426\u663e\u793a", required=false, paramType="query"), @ApiImplicitParam(name="contentAuthor", value="\u6587\u7ae0\u4f5c\u8005", required=false, paramType="query"), @ApiImplicitParam(name="contentSource", value="\u6587\u7ae0\u6765\u6e90", required=false, paramType="query"), @ApiImplicitParam(name="contentDatetime", value="\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="contentSort", value="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="contentImg", value="\u6587\u7ae0\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="contentDescription", value="\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="contentKeyword", value="\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="contentDetails", value="\u6587\u7ae0\u5185\u5bb9", required=false, paramType="query"), @ApiImplicitParam(name="contentUrl", value="\u6587\u7ae0\u8df3\u8f6c\u94fe\u63a5\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="appid", value="\u6587\u7ae0\u7ba1\u7406\u7684\u5e94\u7528id", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore ContentBean content, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
        BasicUtil.startPage();
        List contentList = this.contentBiz.query(content);
        return ResultData.build().success((Object)new EUListBean(contentList, (int)BasicUtil.endPage((List)contentList).getTotal()));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute ContentEntity content, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        model.addAttribute("appId", (Object)BasicUtil.getApp().getAppId());
        return "/cms/content/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore ContentEntity content, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (content.getId() == null) {
            return ResultData.build().error();
        }
        ContentEntity _content = (ContentEntity)((Object)this.contentBiz.getById((Serializable)((Object)content.getId())));
        return ResultData.build().success((Object)_content);
    }

    @ApiOperation(value="\u6839\u636e\u5c01\u9762\u83b7\u53d6\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParam(name="categoryId", value="\u5206\u7c7b\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/getFromFengMian"})
    @ResponseBody
    public ResultData getFromFengMian(@ModelAttribute @ApiIgnore ContentEntity content) {
        if (content.getCategoryId() == null) {
            return ResultData.build().error();
        }
        List list = ((LambdaQueryChainWrapper)this.contentBiz.lambdaQuery().eq(ContentEntity::getCategoryId, (Object)content.getCategoryId())).list();
        if (list.size() > 1) {
            this.LOG.error("\u83b7\u53d6\u5c01\u9762\u6587\u7ae0\u5f02\u5e38");
        }
        return ResultData.build().success(list.size() > 0 ? list.get(0) : null);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="contentTitle", value="\u6587\u7ae0\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6240\u5c5e\u680f\u76ee", required=false, paramType="query"), @ApiImplicitParam(name="contentType", value="\u6587\u7ae0\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="contentDisplay", value="\u662f\u5426\u663e\u793a", required=false, paramType="query"), @ApiImplicitParam(name="contentAuthor", value="\u6587\u7ae0\u4f5c\u8005", required=false, paramType="query"), @ApiImplicitParam(name="contentSource", value="\u6587\u7ae0\u6765\u6e90", required=false, paramType="query"), @ApiImplicitParam(name="contentDatetime", value="\u53d1\u5e03\u65f6\u95f4", required=true, paramType="query"), @ApiImplicitParam(name="contentSort", value="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="contentImg", value="\u6587\u7ae0\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="contentDescription", value="\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="contentKeyword", value="\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="contentDetails", value="\u6587\u7ae0\u5185\u5bb9", required=false, paramType="query"), @ApiImplicitParam(name="contentUrl", value="\u6587\u7ae0\u8df3\u8f6c\u94fe\u63a5\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="appid", value="\u6587\u7ae0\u7ba1\u7406\u7684\u5e94\u7528id", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @LogAnn(title="\u4fdd\u5b58\u6587\u7ae0", businessType=BusinessTypeEnum.INSERT)
    @RequiresPermissions(value={"cms:content:save"})
    public ResultData save(@ModelAttribute @ApiIgnore ContentEntity content, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((Object)content.getContentTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("content.title")}));
        }
        if (!StringUtil.checkLength((String)(content.getContentTitle() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("content.title"), "0", "200"}));
        }
        if (!StringUtil.checkLength((String)(content.getContentAuthor() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("content.author"), "0", "200"}));
        }
        if (!StringUtil.checkLength((String)(content.getContentSource() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("content.source"), "0", "200"}));
        }
        if (StringUtil.isBlank((Object)content.getContentDatetime())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("content.datetime")}));
        }
        if (!StringUtil.checkLength((String)(content.getContentUrl() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("content.url"), "0", "200"}));
        }
        this.contentBiz.save((Object)content);
        return ResultData.build().success((Object)content);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @LogAnn(title="\u5220\u9664\u6587\u7ae0", businessType=BusinessTypeEnum.DELETE)
    @RequiresPermissions(value={"cms:content:del"})
    public ResultData delete(@RequestBody List<ContentEntity> contents, HttpServletResponse response, HttpServletRequest request) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < contents.size(); ++i) {
            ids.add(contents.get(i).getId());
        }
        this.contentBiz.removeByIds(ids);
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u6587\u7ae0\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="contentTitle", value="\u6587\u7ae0\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6240\u5c5e\u680f\u76ee", required=false, paramType="query"), @ApiImplicitParam(name="contentType", value="\u6587\u7ae0\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="contentDisplay", value="\u662f\u5426\u663e\u793a", required=false, paramType="query"), @ApiImplicitParam(name="contentAuthor", value="\u6587\u7ae0\u4f5c\u8005", required=false, paramType="query"), @ApiImplicitParam(name="contentSource", value="\u6587\u7ae0\u6765\u6e90", required=false, paramType="query"), @ApiImplicitParam(name="contentDatetime", value="\u53d1\u5e03\u65f6\u95f4", required=true, paramType="query"), @ApiImplicitParam(name="contentSort", value="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="contentImg", value="\u6587\u7ae0\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="contentDescription", value="\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="contentKeyword", value="\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="contentDetails", value="\u6587\u7ae0\u5185\u5bb9", required=false, paramType="query"), @ApiImplicitParam(name="contentUrl", value="\u6587\u7ae0\u8df3\u8f6c\u94fe\u63a5\u5730\u5740", required=false, paramType="query"), @ApiImplicitParam(name="appid", value="\u6587\u7ae0\u7ba1\u7406\u7684\u5e94\u7528id", required=false, paramType="query"), @ApiImplicitParam(name="createBy", value="\u521b\u5efa\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="createDate", value="\u521b\u5efa\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u4fee\u6539\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u4fee\u6539\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="del", value="\u5220\u9664\u6807\u8bb0", required=false, paramType="query"), @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @LogAnn(title="\u66f4\u65b0\u6587\u7ae0", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"cms:content:update"})
    public ResultData update(@ModelAttribute @ApiIgnore ContentEntity content, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtil.isBlank((Object)content.getContentTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("content.title")}));
        }
        if (!StringUtil.checkLength((String)(content.getContentTitle() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("content.title"), "0", "200"}));
        }
        if (!StringUtil.checkLength((String)(content.getContentAuthor() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("content.author"), "0", "200"}));
        }
        if (!StringUtil.checkLength((String)(content.getContentSource() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("content.source"), "0", "200"}));
        }
        if (StringUtil.isBlank((Object)content.getContentDatetime())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("content.datetime")}));
        }
        if (!StringUtil.checkLength((String)(content.getContentUrl() + ""), (int)0, (int)200)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("content.url"), "0", "200"}));
        }
        this.contentBiz.saveOrUpdate((Object)content);
        return ResultData.build().success((Object)content);
    }
}

