/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action.web;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.bean.CategoryBean;
import net.mingsoft.cms.bean.ContentBean;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.entity.ContentEntity;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.biz.IPageBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@Controller(value="dynamicPageAction")
@RequestMapping(value={"/mcms"})
public class MCmsAction
extends BaseAction {
    @Autowired
    private IPageBiz pageBiz;
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Value(value="${ms.html-dir:html}")
    private String htmlDir;

    @GetMapping(value={"/index.do"})
    @ResponseBody
    public String index(HttpServletRequest req, HttpServletResponse resp) {
        Map map = BasicUtil.assemblyRequestMap();
        map.forEach((k, v) -> map.put(k, v.toString().replaceAll("('|\"|\\\\)", "\\\\$1")));
        map.put("url", BasicUtil.getUrl());
        map.put("isDo", true);
        map.put("modelName", "mcms");
        map.put("html", this.htmlDir);
        String content = "";
        try {
            content = ParserUtil.rendering((String)"index.htm", (Map)map);
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    @ResponseBody
    @GetMapping(value={"/list.do"})
    public String list(HttpServletRequest req, HttpServletResponse resp) {
        Map map = BasicUtil.assemblyRequestMap();
        map.forEach((k, v) -> map.put(k, v.toString().replaceAll("('|\"|\\\\)", "\\\\$1")));
        int typeId = BasicUtil.getInt((String)"typeid", (int)0);
        int size = BasicUtil.getInt((String)"size", (int)10);
        ContentBean contentBean = new ContentBean();
        contentBean.setCategoryId(String.valueOf(typeId));
        List<CategoryBean> columnArticles = this.contentBiz.queryIdsByCategoryIdForParser(contentBean);
        if (columnArticles.size() == 0) {
            return "";
        }
        PageBean page = new PageBean();
        page.setPageNo(BasicUtil.getPageNo());
        int total = PageUtil.totalPage((int)columnArticles.size(), (int)size);
        map.put("column", columnArticles.get(0));
        page.setTotal(total);
        map.put("typeid", typeId);
        map.put("url", BasicUtil.getUrl());
        map.put("pageTag", page);
        map.put("isDo", true);
        map.put("modelName", "mcms");
        map.put("html", this.htmlDir);
        String content = "";
        try {
            content = ParserUtil.rendering((String)columnArticles.get(0).getCategoryListUrl(), (Map)map);
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    @GetMapping(value={"/view.do"})
    @ResponseBody
    public String view(String orderby, String order, HttpServletRequest req, HttpServletResponse resp) {
        ContentEntity article = (ContentEntity)this.contentBiz.getEntity(BasicUtil.getInt((String)"id"));
        if (ObjectUtil.isNull((Object)((Object)article))) {
            throw new BusinessException(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        if (StringUtils.isNotBlank((CharSequence)order) && !order.toLowerCase().equals("asc") && !order.toLowerCase().equals("desc")) {
            throw new BusinessException(this.getResString("err.error", new String[]{this.getResString("order")}));
        }
        orderby = orderby.replaceAll("('|\"|\\\\)", "\\\\$1");
        PageBean page = new PageBean();
        String typeId = BasicUtil.getString((String)"typeid", (String)article.getCategoryId());
        CategoryEntity column = (CategoryEntity)this.categoryBiz.getEntity(Integer.parseInt(typeId));
        String content = "";
        Map map = BasicUtil.assemblyRequestMap();
        map.forEach((k, v) -> map.put(k, v.toString().replaceAll("('|\"|\\\\)", "\\\\$1")));
        map.put("isDo", true);
        map.put("typeid", typeId);
        map.put("modelName", "mcms");
        map.put("url", BasicUtil.getUrl());
        map.put("pageTag", page);
        map.put("id", article.getId());
        map.put("html", this.htmlDir);
        ContentBean contentBean = new ContentBean();
        contentBean.setCategoryId(String.valueOf(typeId));
        contentBean.setOrderBy(orderby);
        contentBean.setOrder(order);
        List<CategoryBean> articleIdList = this.contentBiz.queryIdsByCategoryIdForParser(contentBean);
        HashMap<Integer, String> contentModelMap = new HashMap<Integer, String>();
        ModelEntity contentModel = null;
        for (int artId = 0; artId < articleIdList.size(); ++artId) {
            if (articleIdList.get(artId).getArticleId().equals(article.getId())) {
                continue;
            }
            String categoryParentId = articleIdList.get(artId).getId();
            if (StringUtils.isNotBlank((CharSequence)articleIdList.get(artId).getCategoryParentIds())) {
                categoryParentId = categoryParentId + ',' + articleIdList.get(artId).getCategoryParentIds();
            }
            Integer columnContentModelId = articleIdList.get(artId).getMdiyModelId();
            HashMap<String, Object> parserParams = new HashMap<String, Object>();
            parserParams.put("column", (Object)articleIdList.get(artId));
            if (columnContentModelId != null && columnContentModelId > 0) {
                if (contentModelMap.containsKey(columnContentModelId)) {
                    parserParams.put("tableName", contentModel.getModelTableName());
                } else {
                    contentModel = (ModelEntity)this.modelBiz.getEntity(columnContentModelId.intValue());
                    contentModelMap.put(columnContentModelId, contentModel.getModelTableName());
                    parserParams.put("tableName", contentModel.getModelTableName());
                }
            }
            if (artId > 0) {
                CategoryBean preCaBean = articleIdList.get(artId - 1);
                page.setPreId(preCaBean.getArticleId());
            }
            if (artId + 1 >= articleIdList.size()) break;
            CategoryBean nextCaBean = articleIdList.get(artId + 1);
            page.setNextId(nextCaBean.getArticleId());
            break;
        }
        try {
            content = ParserUtil.rendering((String)column.getCategoryUrl(), (Map)map);
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    @RequestMapping(value={"search"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String search(HttpServletRequest request, HttpServletResponse response) {
        String search = BasicUtil.getString((String)"tmpl", (String)"search.htm");
        PageBean page = new PageBean();
        page.setSize(ParserUtil.getPageSize((String)search, (int)20));
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map field = BasicUtil.assemblyRequestMap();
        HashMap diyFieldName = new HashMap();
        ArrayList filedStr = new ArrayList();
        ArrayList<DiyModelMap> fieldValueList = new ArrayList<DiyModelMap>();
        CategoryEntity column = null;
        ModelEntity contentModel = null;
        String typeId = null;
        String categoryIds = BasicUtil.getString((String)"categoryIds");
        if (StringUtils.isNotBlank((CharSequence)categoryIds) && !categoryIds.contains(",")) {
            typeId = categoryIds;
        }
        if (typeId != null) {
            column = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)typeId)));
            if (column != null && ObjectUtil.isNotNull((Object)column.getMdiyModelId()) && (contentModel = (ModelEntity)this.modelBiz.getEntity(column.getMdiyModelId().intValue())) != null) {
                Map fieldMap = contentModel.getFieldMap();
                for (String s : fieldMap.keySet()) {
                    filedStr.add(fieldMap.get(s));
                }
                params.put("tableName", contentModel.getModelTableName());
            }
            params.put("column", (Object)column);
        }
        if (field != null) {
            for (Map.Entry entry : field.entrySet()) {
                if (entry == null || ObjectUtil.isNull(entry.getValue())) continue;
                String value = entry.getValue().toString().replaceAll("('|\"|\\\\)", "\\\\$1");
                value = this.clearXss(value);
                if (request.getMethod().equals(RequestMethod.GET)) {
                    try {
                        value = new String(value.getBytes("ISO-8859-1"), "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                diyFieldName.put(entry.getKey(), value);
                if (!filedStr.contains(entry.getKey())) continue;
                DiyModelMap diyMap = new DiyModelMap();
                diyMap.setKey((String)entry.getKey());
                diyMap.setValue(value);
                fieldValueList.add(diyMap);
            }
        }
        if (fieldValueList.size() > 0) {
            params.put("diyModel", fieldValueList);
        }
        Map searchMap = field;
        searchMap.put("categoryIds", categoryIds);
        StringBuilder urlParams = new StringBuilder();
        searchMap.forEach((k, v) -> {
            if (v != null) {
                searchMap.put(k, v.toString().replaceAll("('|\"|\\\\)", "\\\\$1"));
                searchMap.put(k, this.clearXss(searchMap.get(k).toString()));
                if (!"size".equals(k) && !"pageNo".equals(k)) {
                    urlParams.append((String)k).append("=").append(searchMap.get(k)).append("&");
                }
            }
        });
        int count = this.contentBiz.getSearchCount(contentModel, fieldValueList, searchMap, BasicUtil.getApp().getAppId(), categoryIds);
        page.setRcount(count);
        params.put("search", searchMap);
        if (BasicUtil.getWebsiteApp() != null) {
            params.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
            params.put("url", BasicUtil.getWebsiteApp().getAppHostUrl());
            params.put("appId", BasicUtil.getWebsiteApp().getAppId());
        } else {
            params.put("url", BasicUtil.getUrl());
            params.put("appDir", BasicUtil.getApp().getAppDir());
        }
        searchMap.put("pageNo", 0);
        int total = PageUtil.totalPage((int)count, (int)page.getSize());
        int pageNo = BasicUtil.getInt((String)"pageNo", (int)1);
        if (pageNo >= total && total != 0) {
            pageNo = total;
        }
        page.setTotal(total);
        page.setPageNo(pageNo);
        String url = params.get("url").toString();
        url = url + request.getServletPath() + "?" + urlParams;
        String pageNoStr = "size=" + page.getSize() + "&pageNo=";
        String nextUrl = url + pageNoStr + (pageNo + 1 > total ? total : pageNo + 1);
        String indexUrl = url + pageNoStr + 1;
        String lastUrl = url + pageNoStr + total;
        String preUrl = url + pageNoStr + (pageNo == 1 ? 1 : pageNo - 1);
        page.setIndexUrl(indexUrl);
        page.setNextUrl(nextUrl);
        page.setPreUrl(preUrl);
        page.setLastUrl(lastUrl);
        params.put("pageTag", page);
        params.put("html", this.htmlDir);
        params.put("isDo", false);
        params.put("modelName", "mcms");
        String content = "";
        try {
            content = ParserUtil.rendering((String)search, params);
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    private String clearXss(String value) {
        if (value == null || "".equals(value)) {
            return value;
        }
        value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        value = value.replaceAll("\\(", "&#40;").replace("\\)", "&#41;");
        value = value.replaceAll("'", "&#39;");
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replace("script", "");
        return value;
    }

    class DiyModelMap {
        String key;
        Object value;

        DiyModelMap() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

