/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.PinYinUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.entity.CategoryEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u5185\u5bb9\u6a21\u5757\u63a5\u53e3"})
@Controller(value="cmsCategoryAction")
@RequestMapping(value={"/${ms.manager.path}/cms/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"cms:category:view"})
    public String index() {
        return "/cms/category/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryTitle", value="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query")})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore CategoryEntity category) {
        BasicUtil.startPage();
        List categoryList = this.categoryBiz.list((Wrapper)new LambdaQueryWrapper((Object)category));
        return ResultData.build().success((Object)new EUListBean(categoryList, (int)BasicUtil.endPage((List)categoryList).getTotal()));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute CategoryEntity category, ModelMap model) {
        model.addAttribute("appId", (Object)BasicUtil.getApp().getAppId());
        return "/cms/category/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"cms:category:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore CategoryEntity category) {
        if (category.getId() == null) {
            return ResultData.build().error();
        }
        CategoryEntity _category = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)category.getId())));
        return ResultData.build().success((Object)_category);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryTitle", value="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6240\u5c5e\u680f\u76ee", required=false, paramType="query"), @ApiImplicitParam(name="categoryType", value="\u680f\u76ee\u7ba1\u7406\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categorySort", value="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="categoryListUrl", value="\u5217\u8868\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryUrl", value="\u5185\u5bb9\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryKeyword", value="\u680f\u76ee\u7ba1\u7406\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="categoryDescrip", value="\u680f\u76ee\u7ba1\u7406\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="categoryImg", value="\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="categoryDiyUrl", value="\u81ea\u5b9a\u4e49\u94fe\u63a5", required=false, paramType="query"), @ApiImplicitParam(name="mdiyModelId", value="\u680f\u76ee\u7ba1\u7406\u7684\u5185\u5bb9\u6a21\u578bid", required=false, paramType="query"), @ApiImplicitParam(name="categoryDatetime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="dictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryFlag", value="\u680f\u76ee\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categoryPath", value="\u680f\u76ee\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @LogAnn(title="\u4fdd\u5b58\u5206\u7c7b", businessType=BusinessTypeEnum.INSERT)
    @RequiresPermissions(value={"cms:category:save"})
    public ResultData save(@ModelAttribute @ApiIgnore CategoryEntity category) {
        if (category.getCategoryImg() == null || !category.getCategoryImg().matches("^\\[.{1,}]$")) {
            category.setCategoryImg("");
        }
        if (StringUtil.isBlank((Object)category.getCategoryTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("category.title")}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryTitle() + ""), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.title"), "1", "100"}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryPath() + ""), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.path"), "1", "100"}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryParentIds() + ""), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.parent.id"), "1", "100"}));
        }
        if (StrUtil.isNotBlank((CharSequence)category.getCategoryPinyin())) {
            if (!category.getCategoryPinyin().matches("^[a-zA-Z0-9]*$")) {
                return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("category.pinyin")}));
            }
            CategoryEntity _category = new CategoryEntity();
            _category.setCategoryPinyin(category.getCategoryPinyin());
            List query = this.categoryBiz.query(_category);
            if (query.size() > 0) {
                return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("category.pinyin")}));
            }
        }
        this.categoryBiz.saveEntity(category);
        return ResultData.build().success((Object)category);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categorys", value="\u5220\u9664\u7684\u680f\u76ee\u96c6\u5408", allowMultiple=true, dataType="CategoryEntity", required=true)})
    @PostMapping(value={"/delete"})
    @ResponseBody
    @LogAnn(title="\u5220\u9664\u5206\u7c7b", businessType=BusinessTypeEnum.DELETE)
    @RequiresPermissions(value={"cms:category:del"})
    public ResultData delete(@RequestBody List<CategoryEntity> categorys) {
        for (int i = 0; i < categorys.size(); ++i) {
            this.categoryBiz.delete(categorys.get(i).getId());
        }
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u5206\u7c7b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="categoryTitle", value="\u680f\u76ee\u7ba1\u7406\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="categoryId", value="\u6240\u5c5e\u680f\u76ee", required=false, paramType="query"), @ApiImplicitParam(name="categoryType", value="\u680f\u76ee\u7ba1\u7406\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categorySort", value="\u81ea\u5b9a\u4e49\u987a\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="categoryListUrl", value="\u5217\u8868\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryUrl", value="\u5185\u5bb9\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="categoryKeyword", value="\u680f\u76ee\u7ba1\u7406\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="categoryDescrip", value="\u680f\u76ee\u7ba1\u7406\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="categoryImg", value="\u7f29\u7565\u56fe", required=false, paramType="query"), @ApiImplicitParam(name="categoryDiyUrl", value="\u81ea\u5b9a\u4e49\u94fe\u63a5", required=false, paramType="query"), @ApiImplicitParam(name="mdiyModelId", value="\u680f\u76ee\u7ba1\u7406\u7684\u5185\u5bb9\u6a21\u578bid", required=false, paramType="query"), @ApiImplicitParam(name="categoryDatetime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="dictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryFlag", value="\u680f\u76ee\u5c5e\u6027", required=false, paramType="query"), @ApiImplicitParam(name="categoryPath", value="\u680f\u76ee\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="categoryParentId", value="\u7236\u7c7b\u578b\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @LogAnn(title="\u66f4\u65b0\u5206\u7c7b", businessType=BusinessTypeEnum.UPDATE)
    @RequiresPermissions(value={"cms:category:update"})
    public ResultData update(@ModelAttribute @ApiIgnore CategoryEntity category) {
        if (category.getCategoryImg() == null || !category.getCategoryImg().matches("^\\[.{1,}]$")) {
            category.setCategoryImg("");
        }
        if (StringUtil.isBlank((Object)category.getCategoryTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("category.title")}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryTitle() + ""), (int)1, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.title"), "1", "100"}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryPath() + ""), (int)0, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.path"), "1", "100"}));
        }
        if (!StringUtil.checkLength((String)(category.getCategoryParentIds() + ""), (int)0, (int)100)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("category.parent.id"), "1", "100"}));
        }
        if (StrUtil.isNotBlank((CharSequence)category.getCategoryPinyin()) && !((CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)category.getId())))).getCategoryPinyin().equals(category.getCategoryPinyin())) {
            if (!category.getCategoryPinyin().matches("^[a-zA-Z0-9]*$")) {
                return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("category.pinyin")}));
            }
            CategoryEntity _category = new CategoryEntity();
            _category.setCategoryPinyin(category.getCategoryPinyin());
            List query = this.categoryBiz.query(_category);
            if (query.size() > 0) {
                return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("category.pinyin")}));
            }
        }
        String pingYin = PinYinUtil.getPingYin((String)category.getCategoryTitle());
        if (StrUtil.isNotBlank((CharSequence)category.getCategoryPinyin())) {
            pingYin = category.getCategoryPinyin();
        }
        CategoryEntity categoryEntity = new CategoryEntity();
        categoryEntity.setCategoryPinyin(pingYin);
        CategoryEntity categoryBizEntity = (CategoryEntity)((Object)this.categoryBiz.getEntity(categoryEntity));
        category.setCategoryPinyin(pingYin);
        if (categoryBizEntity != null && !categoryBizEntity.getId().equals(category.getId())) {
            category.setCategoryPinyin(pingYin + category.getId());
        }
        CategoryEntity _category = new CategoryEntity();
        _category.setId(category.getId());
        List<CategoryEntity> categoryList = this.categoryBiz.queryChildren(_category);
        if (categoryList.size() > 1) {
            for (CategoryEntity item : categoryList) {
                if (!item.getId().equals(category.getCategoryId())) continue;
                return ResultData.build().error(this.getResString("cannot.select.child"));
            }
            category.setLeaf(false);
        } else {
            category.setLeaf(true);
        }
        this.categoryBiz.updateEntity(category);
        return ResultData.build().success((Object)category);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u62fc\u97f3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="categoryPinyin", value="\u680f\u76ee\u7ba1\u62fc\u97f3", required=true, paramType="query")})
    @GetMapping(value={"/verifyPingYin"})
    @ResponseBody
    public ResultData verifyPingYin(@ModelAttribute @ApiIgnore CategoryEntity category) {
        long count = this.categoryBiz.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().ne(StrUtil.isNotBlank((CharSequence)category.getId()), CategoryEntity::getId, (Object)category.getId())).eq(CategoryEntity::getCategoryPinyin, (Object)category.getCategoryPinyin()));
        if (count > 0L) {
            return ResultData.build().error("\u5b58\u5728\u76f8\u540c\u62fc\u97f3\u7684\u680f\u76ee");
        }
        return ResultData.build().success();
    }

    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u6a21\u7248")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="dictId", value="\u5b57\u5178", required=true, paramType="query")})
    @GetMapping(value={"/updateTemplate"})
    @ResponseBody
    @RequiresPermissions(value={"cms:category:update"})
    public ResultData updateTemplate(@ModelAttribute @ApiIgnore CategoryEntity category) {
        if (category == null || StringUtils.isEmpty((CharSequence)category.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
        }
        category = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)category.getId())));
        category.setCategoryParentIds(null);
        List<CategoryEntity> childs = this.categoryBiz.queryChildren(category);
        for (int i = 0; i < childs.size(); ++i) {
            if (!childs.get(i).getCategoryType().equals(category.getCategoryType())) continue;
            childs.get(i).setCategoryUrl(category.getCategoryUrl());
            childs.get(i).setCategoryListUrl(category.getCategoryListUrl());
            this.categoryBiz.updateEntity(childs.get(i));
        }
        return ResultData.build().success();
    }

    @ApiOperation(value="\u590d\u5236\u680f\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7f16\u53f7", required=true, paramType="query")})
    @GetMapping(value={"/copyCategory"})
    @ResponseBody
    @RequiresPermissions(value={"cms:category:save"})
    public ResultData copyCategory(@ModelAttribute @ApiIgnore CategoryEntity category) {
        if (category == null || StringUtils.isEmpty((CharSequence)category.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
        }
        this.categoryBiz.copyCategory(category);
        return ResultData.build().success();
    }
}

