/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.config;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.spring.stat.BeanTypeAutoProxyCreator;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.File;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.Filter;
import net.mingsoft.basic.filter.XSSEscapeFilter;
import net.mingsoft.basic.interceptor.ActionInterceptor;
import net.mingsoft.config.MSProperties;
import net.mingsoft.mdiy.biz.IConfigBiz;
import net.mingsoft.mdiy.entity.ConfigEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    @Resource
    private IConfigBiz configBiz;
    @Resource
    private MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter;

    @Bean
    public ActionInterceptor actionInterceptor() {
        return new ActionInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.actionInterceptor()).excludePathPatterns(new String[]{"/static/**", "/app/**", "/webjars/**", "/*.html", "/*.htm"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String uploadMapping = MSProperties.upload.mapping;
        String uploadFolderPath = MSProperties.upload.path;
        String template = MSProperties.upload.template;
        String htmlDir = MSProperties.diy.htmlDir;
        registry.addResourceHandler(new String[]{uploadMapping}).addResourceLocations(new String[]{"/" + uploadFolderPath + "/", "file:" + uploadFolderPath + "/"});
        registry.addResourceHandler(new String[]{"/" + template + "/**"}).addResourceLocations(new String[]{"/" + template + "/", "file:" + template + "/"});
        registry.addResourceHandler(new String[]{"/" + htmlDir + "/**"}).addResourceLocations(new String[]{"/" + htmlDir + "/", "file:" + htmlDir + "/"});
        registry.addResourceHandler(new String[]{"/app/**"}).addResourceLocations(new String[]{"/app/", "file:app/", "classpath:/app/"});
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"/static/", "file:static/", "classpath:/static/", "classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/api/**"}).addResourceLocations(new String[]{"/api/", "file:api/", "classpath:/api/"});
        if (new File(uploadFolderPath).isAbsolute()) {
            registry.addResourceHandler(new String[]{uploadMapping}).addResourceLocations(new String[]{"file:" + uploadFolderPath + "/"});
        }
    }

    @Bean
    public BeanTypeAutoProxyCreator beanTypeAutoProxyCreator() {
        BeanTypeAutoProxyCreator beanTypeAutoProxyCreator = new BeanTypeAutoProxyCreator();
        beanTypeAutoProxyCreator.setTargetBeanType(DruidDataSource.class);
        beanTypeAutoProxyCreator.setInterceptorNames(new String[]{"druidStatInterceptor"});
        return beanTypeAutoProxyCreator;
    }

    @Bean
    public FilterRegistrationBean xssFilterRegistration(@Value(value="${ms.xss.enable:true}") boolean xssEnable, @Value(value="${ms.xss.filter-url}") String filterUrl, @Value(value="${ms.xss.exclude-url}") String excludeUrl, @Value(value="${ms.xss.exclude-filed}") String excludeFiled) {
        XSSEscapeFilter xssFilter = new XSSEscapeFilter();
        HashMap<String, String> initParameters = new HashMap<String, String>();
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName("XSSFilter");
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(Integer.MIN_VALUE);
        if (filterUrl != null && StrUtil.isNotBlank((CharSequence)filterUrl)) {
            xssFilter.includes.addAll(Arrays.asList(filterUrl.split(",")));
        } else {
            xssFilter.includes.add("/**");
        }
        if (excludeUrl != null && StrUtil.isNotBlank((CharSequence)excludeUrl)) {
            xssFilter.excludes.addAll(Arrays.asList(excludeUrl.split(",")));
        } else {
            xssFilter.excludes.add(MSProperties.manager.path + "/**");
        }
        if (excludeFiled != null && StrUtil.isNotBlank((CharSequence)excludeFiled)) {
            xssFilter.excludesFiled.addAll(Arrays.asList(excludeFiled.split(",")));
        }
        initParameters.put("isIncludeRichText", "false");
        registration.setInitParameters(initParameters);
        registration.setFilter((Filter)xssFilter);
        registration.setEnabled(xssEnable);
        return registration;
    }

    @Bean
    public ServletListenerRegistrationBean<RequestContextListener> requestContextListenerRegistration() {
        return new ServletListenerRegistrationBean((EventListener)new RequestContextListener());
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/index");
        registry.setOrder(Integer.MIN_VALUE);
        super.addViewControllers(registry);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.mappingJackson2HttpMessageConverter);
        super.configureMessageConverters(converters);
    }

    @Bean
    public ExecutorService crawlExecutorPool() {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        return pool;
    }

    public Map getMap(String configName) {
        if (!StringUtils.isEmpty((CharSequence)configName) && !StringUtils.isEmpty((CharSequence)configName)) {
            ConfigEntity configEntity = new ConfigEntity();
            configEntity.setConfigName(configName);
            configEntity = (ConfigEntity)this.configBiz.getOne((Wrapper)new QueryWrapper((Object)configEntity));
            return configEntity != null && !StringUtils.isEmpty((CharSequence)configEntity.getConfigData()) ? (Map)JSONUtil.toBean((String)configEntity.getConfigData(), HashMap.class) : null;
        }
        return null;
    }
}

