/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.action.web;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.json.JSONUtil;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.action.BaseAction;
import net.mingsoft.cms.biz.ICategoryBiz;
import net.mingsoft.cms.biz.IContentBiz;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.mdiy.bean.PageBean;
import net.mingsoft.mdiy.biz.IModelBiz;
import net.mingsoft.mdiy.entity.ModelEntity;
import net.mingsoft.mdiy.util.ConfigUtil;
import net.mingsoft.mdiy.util.ParserUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@Controller(value="dynamicPageAction")
@RequestMapping(value={"/mcms"})
public class MCmsAction
extends BaseAction {
    @Autowired
    private IContentBiz contentBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Value(value="${ms.diy.html-dir:html}")
    private String htmlDir;

    @RequestMapping(value={"search"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"text/html;charset=utf-8"})
    @ResponseBody
    public String search(HttpServletRequest request, HttpServletResponse response) {
        String search = BasicUtil.getString((String)"tmpl", (String)"search.htm");
        PageBean page = new PageBean();
        page.setSize(ParserUtil.getPageSize((String)search, (int)20));
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map field = BasicUtil.assemblyRequestMap();
        HashMap diyFieldName = new HashMap();
        ArrayList filedStr = new ArrayList();
        ArrayList<DiyModelMap> fieldValueList = new ArrayList<DiyModelMap>();
        CategoryEntity column = null;
        ModelEntity contentModel = null;
        String typeId = null;
        String categoryIds = BasicUtil.getString((String)"categoryIds");
        if ("null".equals(categoryIds)) {
            categoryIds = null;
        }
        if (StringUtils.isNotBlank((CharSequence)categoryIds) && !categoryIds.contains(",")) {
            typeId = categoryIds;
        }
        if (typeId != null) {
            column = (CategoryEntity)((Object)this.categoryBiz.getById((Serializable)((Object)typeId)));
            if (column != null && ObjectUtil.isNotNull((Object)column.getMdiyModelId()) && (contentModel = (ModelEntity)this.modelBiz.getById((Serializable)((Object)column.getMdiyModelId()))) != null) {
                Map fieldMap = contentModel.getFieldMap();
                for (String s : fieldMap.keySet()) {
                    filedStr.add(fieldMap.get(s));
                }
                params.put("tableName", contentModel.getModelTableName());
            }
            params.put("column", (Object)column);
        }
        if (field != null) {
            for (Map.Entry entry : field.entrySet()) {
                if (entry == null || ObjectUtil.isNull(entry.getValue())) continue;
                String value = entry.getValue().toString().replaceAll("('|\"|\\\\)", "\\\\$1");
                value = this.clearXss(value);
                if (request.getMethod().equals(RequestMethod.GET)) {
                    try {
                        value = new String(value.getBytes("ISO-8859-1"), "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                diyFieldName.put(entry.getKey(), value);
                if (!filedStr.contains(entry.getKey())) continue;
                DiyModelMap diyMap = new DiyModelMap();
                diyMap.setKey((String)entry.getKey());
                diyMap.setValue(value);
                fieldValueList.add(diyMap);
            }
        }
        if (fieldValueList.size() > 0) {
            params.put("diyModel", fieldValueList);
        }
        Map searchMap = field;
        String contentTag = BasicUtil.getString((String)"content_tag");
        if (StringUtils.isNotBlank((CharSequence)contentTag)) {
            searchMap.put("content_tag", contentTag);
        }
        searchMap.put("categoryIds", categoryIds);
        StringBuilder urlParams = new StringBuilder();
        searchMap.forEach((k, v) -> {
            if (v != null) {
                searchMap.put(k, v.toString().replaceAll("('|\"|\\\\)", "\\\\$1"));
                searchMap.put(k, this.clearXss(searchMap.get(k).toString()));
                if (!"size".equals(k) && !"pageNo".equals(k)) {
                    urlParams.append((String)k).append("=").append(searchMap.get(k)).append("&");
                }
            }
        });
        int count = this.contentBiz.getSearchCount(contentModel, fieldValueList, searchMap, categoryIds);
        page.setRcount(count);
        params.put("search", searchMap);
        Boolean shortSwitch = ConfigUtil.getBoolean((String)"\u77ed\u94fe\u914d\u7f6e", (String)"shortLinkSwitch");
        if (BasicUtil.getWebsiteApp() != null) {
            params.put("appDir", BasicUtil.getWebsiteApp().getAppDir());
            params.put("url", BasicUtil.getWebsiteApp().getAppHostUrl());
            params.put("appId", BasicUtil.getWebsiteApp().getAppId());
        } else if (shortSwitch.booleanValue()) {
            params.put("url", BasicUtil.getUrl());
            params.put("appDir", "");
        } else {
            params.put("url", BasicUtil.getUrl());
            params.put("appDir", BasicUtil.getApp().getAppDir());
        }
        params.put("shortSwitch", shortSwitch);
        String contextPath = BasicUtil.getContextPath();
        if (StringUtils.isNotBlank((CharSequence)contextPath) && "/".equalsIgnoreCase(contextPath)) {
            contextPath = "";
        }
        params.putIfAbsent("contextPath", contextPath);
        searchMap.put("pageNo", 0);
        int total = PageUtil.totalPage((int)count, (int)page.getSize());
        int pageNo = BasicUtil.getInt((String)"pageNo", (int)1);
        if (pageNo >= total && total != 0) {
            pageNo = total;
        }
        page.setTotal(total);
        page.setPageNo(pageNo);
        String url = request.getServletPath() + "?" + urlParams;
        String pageNoStr = "size=" + page.getSize() + "&pageNo=";
        String nextUrl = url + pageNoStr + (pageNo + 1 > total ? total : pageNo + 1);
        String indexUrl = url + pageNoStr + 1;
        String lastUrl = url + pageNoStr + total;
        String preUrl = url + pageNoStr + (pageNo == 1 ? 1 : pageNo - 1);
        page.setIndexUrl(indexUrl);
        page.setNextUrl(nextUrl);
        page.setPreUrl(preUrl);
        page.setLastUrl(lastUrl);
        params.put("pageTag", page);
        params.put("html", this.htmlDir);
        params.put("isDo", false);
        params.put("modelName", "mcms");
        String content = "";
        try {
            content = ParserUtil.rendering((String)search, params);
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    private String clearXss(String value) {
        if (value == null || "".equals(value)) {
            return value;
        }
        value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        value = value.replaceAll("\\(", "&#40;").replace("\\)", "&#41;");
        value = value.replaceAll("'", "&#39;");
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replace("script", "");
        return value;
    }

    class DiyModelMap {
        private String key;
        private Object value;

        DiyModelMap() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            return JSONUtil.toJsonStr((Object)this);
        }
    }
}

