/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.cms.aop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.cms.constant.e.CategoryDisplayEnum;
import net.mingsoft.cms.constant.e.CategoryIsSearchEnum;
import net.mingsoft.cms.constant.e.CategoryTypeEnum;
import net.mingsoft.cms.dao.ICategoryDao;
import net.mingsoft.cms.dao.IContentDao;
import net.mingsoft.cms.entity.CategoryEntity;
import net.mingsoft.cms.entity.ContentEntity;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="CategoryAop")
public class CategoryAop
extends BaseAop {
    @Value(value="${ms.diy.html-dir:html}")
    private String htmlDir;
    @Autowired
    private ICategoryDao categoryDao;
    @Autowired
    private IContentDao contentDao;

    @Pointcut(value="execution(* net.mingsoft.cms.action.CategoryAction.delete(..)) ")
    public void delete() {
    }

    @Pointcut(value="execution(* net.mingsoft.cms.action.CategoryAction.save(..)) ")
    public void save() {
    }

    @Pointcut(value="execution(* net.mingsoft.cms.action.CategoryAction.update(..)) ")
    public void update() {
    }

    @Around(value="save() || update()")
    public ResultData move(ProceedingJoinPoint pjp) throws Throwable {
        boolean flag;
        CategoryEntity parent;
        LambdaUpdateWrapper wrapper;
        List ids;
        CategoryEntity category = (CategoryEntity)((Object)this.getType((JoinPoint)pjp, CategoryEntity.class));
        if (category == null) {
            throw new BusinessException("\u680f\u76ee\u4e0d\u5b58\u5728!");
        }
        Object obj = pjp.proceed(pjp.getArgs());
        ResultData resultData = (ResultData)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)obj), ResultData.class);
        category = (CategoryEntity)((Object)resultData.getData(CategoryEntity.class));
        if (category == null) {
            return resultData;
        }
        if (CategoryDisplayEnum.DISABLE.toString().equalsIgnoreCase(category.getCategoryDisplay())) {
            ids = this.categoryDao.queryChildren(category).stream().map(CategoryEntity::getId).collect(Collectors.toList());
            wrapper = new UpdateWrapper().lambda();
            wrapper.set(CategoryEntity::getCategoryDisplay, (Object)CategoryDisplayEnum.DISABLE.toString());
            wrapper.in(CategoryEntity::getId, ids);
            this.categoryDao.update(null, (Wrapper)wrapper);
        }
        if (CategoryIsSearchEnum.DISABLE.toString().equalsIgnoreCase(category.getCategoryIsSearch())) {
            ids = this.categoryDao.queryChildren(category).stream().map(CategoryEntity::getId).collect(Collectors.toList());
            wrapper = new UpdateWrapper().lambda();
            wrapper.set(CategoryEntity::getCategoryIsSearch, (Object)CategoryIsSearchEnum.DISABLE.toString());
            wrapper.in(CategoryEntity::getId, ids);
            this.categoryDao.update(null, (Wrapper)wrapper);
        }
        if ((parent = (CategoryEntity)((Object)this.categoryDao.selectById((Serializable)((Object)category.getCategoryId())))) == null) {
            return resultData;
        }
        boolean bl = flag = parent.getLeaf() == false && StringUtils.equals((CharSequence)parent.getCategoryType(), (CharSequence)CategoryTypeEnum.LIST.toString());
        if (flag) {
            String categoryIds;
            parent.setCategoryUrl("");
            this.categoryDao.updateById((Object)parent);
            CategoryEntity returnCategory = (CategoryEntity)((Object)JSONUtil.toBean((String)resultData.get((Object)"data").toString(), CategoryEntity.class));
            String string = categoryIds = StringUtils.isEmpty((CharSequence)parent.getCategoryParentIds()) ? returnCategory.getId() : parent.getCategoryParentIds() + "," + returnCategory.getId();
            if (!StringUtils.equals((CharSequence)returnCategory.getCategoryType(), (CharSequence)CategoryTypeEnum.LIST.toString())) {
                LambdaQueryWrapper contentDeleteWrapper = new QueryWrapper().lambda();
                contentDeleteWrapper.eq(ContentEntity::getCategoryId, (Object)parent.getId());
                List list = this.contentDao.selectList((Wrapper)contentDeleteWrapper);
                if (CollectionUtil.isNotEmpty((Collection)list)) {
                    String[] ids2 = (String[])ArrayUtil.toArray((Collection)list.stream().map(ContentEntity::getId).collect(Collectors.toList()), String.class);
                    this.contentDao.delete(ids2);
                }
            }
            LambdaUpdateWrapper contentWrapper = new UpdateWrapper().lambda();
            contentWrapper.set(ContentEntity::getCategoryId, (Object)returnCategory.getId());
            contentWrapper.eq(ContentEntity::getCategoryId, (Object)parent.getId());
            this.contentDao.update((Object)new ContentEntity(), (Wrapper)contentWrapper);
            return resultData;
        }
        return resultData;
    }

    @After(value="delete()")
    public void delete(JoinPoint jp) {
        List categoryEntities = (List)this.getJsonParam(jp);
        for (CategoryEntity categoryEntity : categoryEntities) {
            this.deleteCategoryHtml(categoryEntity.getCategoryPath());
        }
    }

    public void deleteCategoryHtml(String categoryPath) {
        if (StringUtils.isEmpty((CharSequence)categoryPath) || categoryPath.contains("../") || categoryPath.contains("..\\")) {
            this.LOG.error("\u975e\u6cd5\u8def\u5f84\uff1a{}", (Object)categoryPath);
            throw new BusinessException("\u975e\u6cd5\u8def\u5f84");
        }
        String htmlPath = BasicUtil.getRealPath((String)this.htmlDir);
        String appDir = BasicUtil.getApp().getAppDir();
        boolean flag = FileUtil.del((String)(htmlPath + File.separator + appDir + categoryPath));
        if (flag) {
            this.LOG.info("\u5220\u9664\u9759\u6001\u6587\u4ef6\u5939\u6210\u529f\uff01");
        } else {
            this.LOG.info("\u5220\u9664\u5931\u8d25\uff01");
        }
    }
}

