<!-- 
   ////////////////////////////////////////////////////////////////////////////////
   //
   //                  ObjectLab is sponsoring QALab
   // 
   // Based in London, we are world leaders in the design and development 
   // of bespoke applications for the Securities Financing markets.
   // 
   // <a href="http://www.objectlab.co.uk/open">Click here to learn more</a>
   //           ___  _     _           _   _          _
   //          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
   //         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
   //         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
   //          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
   //                   |__/
   //
   //                   http://www.ObjectLab.co.uk
   //
   //QALab is released under the GNU General Public License.
   //
   //QALab: Collects QA Statistics from your build over time.
   //2005+, ObjectLab Ltd
   //
   //This library is free software; you can redistribute it and/or
   //modify it under the terms of the GNU General Public
   //License as published by the Free Software Foundation; either
   //version 2.1 of the License, or (at your option) any later version.
   //
   //This library is distributed in the hope that it will be useful,
   //but WITHOUT ANY WARRANTY; without even the implied warranty of
   //MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   //General Public License for more details.
   //
   //You should have received a copy of the GNU General Public
   //License along with this library; if not, write to the Free Software
   //Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   //
   ////////////////////////////////////////////////////////////////////////////////
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   version="1.0" xmlns:lxslt="http://xml.apache.org/xslt"
   xmlns:redirect="http://xml.apache.org/xalan/redirect"
   extension-element-prefixes="redirect">
   <xsl:output method="xml" indent="yes" encoding="US-ASCII" />
   <xsl:param name="targetdir" />
   <xsl:param name="type" />
   <xsl:param name="offset" />
   <!-- Used for the removal of duplicated -->
   <xsl:key name="results-by-date" match="summaryresult" use="@date"/>
   <xsl:key name="file-results-by-date" match="result" use="concat(@date, '--', parent::file/@id)" />    
   <xsl:template match="qalab">
      <xsl:variable name="afile"
         select="concat($targetdir,'/index.xml')" />
      <!-- create the index.html 
      <redirect:write file="{$afile}">
         <xsl:call-template name="index.xml" />
      </redirect:write>
      <redirect:write file="{$targetdir}/stylesheet.css">
         <xsl:call-template name="stylesheet.css" />
      </redirect:write>
      -->
      <redirect:write file="{$targetdir}/all-packages.xml">
         <xsl:call-template name="Classes" />
      </redirect:write>
      <xsl:call-template name="Files" />
      <!-- 
            <redirect:write file="{$targetdir}/overview-summary.xml">
         <xsl:call-template name="Main-Summary" />
      </redirect:write>
      -->
   </xsl:template>
   <xsl:template name="index.xml">
      <document>
         <body>
            <section>
               <xsl:attribute name="name">Historical QALab Statistics</xsl:attribute>        
               <table width="100%">
                  <tr align="left">
                     <td>QALab Menu</td>
                     <td>[<a href="index.html">Summary</a>] [<a href="all-packages.html">File Index</a> ]</td>
                  </tr>
               </table>
               <p>Calculated for type: <xsl:value-of select="$type" /></p>
      
               <p>Click on charts to see the list of individual files.</p>
               <p>
                  <a href="all-packages.html">
                     <img src="summary.png">More</img>
                  </a>
               </p>
               <p>
                  <a href="all-packages.html">
                     <img src="cobertura-summary.png">More</img>
                  </a>
               </p>

               <p>
                  <table class="log" border="0" cellpadding="5"
                     cellspacing="2" width="100%">
                     <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Files</th>
                        <th>Errors</th>
                     </tr>
                     <xsl:for-each
                        select="summary/summaryresult[contains($type,@type)]">
                        <xsl:sort select="@date" order="descending" />
                        <tr>
                           <xsl:call-template name="alternated-row" />
                           <td>
                              <xsl:value-of select="@date" />
                           </td>
                           <td>
                              <xsl:value-of select="@type" />
                           </td>
                           <td>
                              <xsl:value-of select="@filecount" />
                           </td>
                           <td>
                              <xsl:value-of select="@statvalue" />
                           </td>
                        </tr>
                     </xsl:for-each>
                  </table>
               </p>

            </section>
         </body>
      </document>
   </xsl:template>

   <xsl:template name="Files">
      <xsl:for-each select="file">
         <xsl:variable name="jpgfile" select="translate(@id, '/', '_')" />
         <xsl:variable name="redirectfile"
            select="translate(@id, '/', '_')" />
         <xsl:if test="count(result[contains($type,@type)])>0">
            <xsl:variable name="afile"
               select="concat($redirectfile,'.xml')" />
            <redirect:write file="{$targetdir}/{$afile}">
               <document>
                  <body>
                     <section name="QALab for individual file">
                     <table width="100%">
                        <tr align="left">
                           <td>QALab Menu</td>
                           <td align="right">[<a href="../qalab-report.html">Summary</a>] [<a href="all-packages.html">File Index</a> ]</td>
                        </tr>
                     </table>
                     <subsection>
                           <xsl:attribute name="name"><xsl:value-of select="@id" /></xsl:attribute>
                        <p><a>
                           <xsl:attribute name="name">PK<xsl:value-of select="@id" />
                           </xsl:attribute>
                           <xsl:variable name="srcfile"
                              select="substring-before(@path,'.java')" />
                           <xsl:attribute name="href">
                              <xsl:value-of
                                 select="concat('../xref/' , $srcfile, '.html')" />
                           </xsl:attribute>
                           See code for <xsl:value-of select="@path" />
                        </a></p>
                     </subsection>
                     <a>
                        <xsl:attribute name="href">
                           <xsl:value-of
                              select="concat($jpgfile, '.png')" />
                        </xsl:attribute>
                        <img>
                           <xsl:attribute name="src">
                              <xsl:value-of
                                 select="concat($jpgfile, '.png')" />
                           </xsl:attribute>
                           a
                        </img>
                     </a>
                     <xsl:apply-templates select="." /> 
                     </section>
                  </body>
               </document>
            </redirect:write>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>

   <!-- Produce the file table rows -->
   <xsl:template match="file">
      <table>
      <p><xsl:value-of select="@id" /></p>
      <tr><th>Date</th> 
          <th>Checkstyle</th> 
		  <th>PMD</th> 
		  <th>FindBugs</th> 
		  <th>Simian</th> 
		  <th>PMD CPD</th> 
		  <th>Cobertura line</th> 
		  <th>Cobertura Branch</th> 
	  </tr>
      <xsl:for-each select="result[count(. | key('file-results-by-date', concat(@date, '--', parent::file/@id))[1] )=1]">
       <xsl:sort select="@date" order="descending" />
       <tr>
         <xsl:call-template name="result-line">
            <xsl:with-param name="results" select="key('file-results-by-date', concat(@date, '--', parent::file/@id))" /> 
         </xsl:call-template>
       </tr>
      </xsl:for-each>
      </table>
   </xsl:template>

   <xsl:template name="result-line">
     <xsl:param name="results" /> 
     <td><xsl:value-of select="$results/@date" /></td>
     <td><xsl:value-of select="sum($results[@type='checkstyle']/@statvalue)" /></td>
     <td><xsl:value-of select="sum($results[@type='pmd']/@statvalue)" /></td>
     <td><xsl:value-of select="sum($results[@type='findbugs']/@statvalue)" /></td>
     <td><xsl:value-of select="sum($results[@type='simian']/@statvalue)" /></td>
     <td><xsl:value-of select="sum($results[@type='pmd-cpd']/@statvalue)" /></td>
     <td><xsl:value-of select="sum($results[@type='cobertura-line']/@statvalue)" /></td>
     <td><xsl:value-of select="sum($results[@type='cobertura-branch']/@statvalue)" /></td>
  </xsl:template>

   <xsl:template name="Classes">
      <document>
         <body>
            <section name="QALab File Index">
            <table width="100%">
               <tr align="left">
                  <td>QALab Menu</td>
                  <td align="left">
                     <a name="top">[<a href="../qalab-report.html">Summary</a>]</a> [<a href="#current">current files</a>] [<a href="#past">past files</a>]</td>
               </tr>
            </table>
            <a name="current"></a><subsection name="Current Files">
            <table width="100%">
               <xsl:for-each select="file">
                  <xsl:sort select="@id" />
                  <xsl:if
                     test="count(result[contains($type,@type)])>0">
                     <xsl:call-template name="ListofClassesCurrent" />
                  </xsl:if>
               </xsl:for-each>
            </table>
            </subsection>
            <subsection name="Past Files">
            <a name="past">
            [<a href="#top">top</a>]
            </a>
            <table width="100%">
               <xsl:for-each select="file">
                  <xsl:sort select="@id" />
                  <xsl:if
                     test="count(result[contains($type,@type)])>0">
                     <xsl:call-template name="ListofClassesPast" />
                  </xsl:if>
               </xsl:for-each>
            </table>
            </subsection>
            </section>
         </body>
      </document>
   </xsl:template>
   <xsl:template name="ListofClassesCurrent">
      <xsl:variable name="date"
         select="substring(result[last()]/@date,1,10)" />
      <xsl:variable name="redirectfile"
         select="translate(@id, '/', '_')" />
      <xsl:if
         test="translate($date,'-','') &gt; translate($offset,'-','')">
         <tr>
            <td>
               <a>
                  <xsl:attribute name="href">
                     <xsl:value-of
                        select="concat($redirectfile,'.html')" />
                  </xsl:attribute>
                  <xsl:value-of select="@path" />
               </a>
            </td>
         </tr>
      </xsl:if>
   </xsl:template>
   <xsl:template name="ListofClassesPast">
      <xsl:variable name="date"
         select="substring(result[last()]/@date,1,10)" />
      <xsl:variable name="redirectfile"
         select="translate(@id, '/', '_')" />
      <xsl:choose>
         <xsl:when
            test="translate($date,'-','') &lt; translate($offset,'-','')">
         </xsl:when>
         <xsl:otherwise>
            <tr>
               <td>
                  <a>
                     <xsl:attribute name="href">
                        <xsl:value-of
                           select="concat($redirectfile,'.html')" />
                     </xsl:attribute>
                     <xsl:value-of select="@path" />
                  </a>
               </td>
            </tr>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="Main-Summary">
      <document>
         <body>
            <section name="Summary">
               <p>
                  <a href="summary.png">
                     <img src="summary.png">a</img>
                  </a>
               </p>
               <p>
                  <a href="cobertura-summary.png">
                     <img src="cobertura-summary.png">a</img>
                  </a>
               </p>

               <p>
                  <table class="log" border="0" cellpadding="5"
                     cellspacing="2" width="100%">
                     <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Files</th>
                        <th>Errors</th>
                     </tr>
                     <xsl:for-each
                        select="summary/summaryresult[contains($type,@type)]">
                        <xsl:sort select="@date" order="descending" />
                        <tr>
                           <xsl:call-template name="alternated-row" />
                           <td>
                              <xsl:value-of select="@date" />
                           </td>
                           <td>
                              <xsl:value-of select="@type" />
                           </td>
                           <td>
                              <xsl:value-of select="@filecount" />
                           </td>
                           <td>
                              <xsl:value-of select="@statvalue" />
                           </td>
                        </tr>
                     </xsl:for-each>
                  </table>
               </p>
            </section>
         </body>
      </document>
   </xsl:template>
   <xsl:template name="alternated-row">
      <xsl:attribute name="class">
         <xsl:if test="position() mod 2 = 1">a</xsl:if>
         <xsl:if test="position() mod 2 = 0">b</xsl:if>
      </xsl:attribute>
   </xsl:template>
</xsl:stylesheet>
