package net.objectlab.qalab.m2.util;

import net.objectlab.qalab.util.TaskLogger;
import org.apache.maven.plugin.Mojo;

/**
 * A QALab TaskLogger for Maven2 plugins.
 * @author <a href="http://www.davesag.com">Dave Sag</a>.
 */
public final class Maven2TaskLogger implements TaskLogger {

    /** the maven2 plugin. */
    private final transient Mojo theMojo;

    /**
     * Constructor that will hide the specific logging mechanism.
     * @param aMojo a Maven2 Mojo
     */
    public Maven2TaskLogger(final Mojo aMojo) {
        theMojo = aMojo;
    }

    /**
     * Uses the maven2 mechanism to log the text.
     * @param text to be logged.
     */
    public void log(final String text) {
        theMojo.getLog().info(text);
    }
}
