package net.objectlab.qalab.m2.util;

import java.io.File;
import java.io.IOException;
import java.io.FileNotFoundException;
import java.io.InputStream;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

/**
 * Some handy utils for the QALab maven 2 plugin.
 * @author <a href="http://www.davesag.com">Dave Sag</a>.
 */
public final class Utils {

    /**
     * private contructor as this is a utils class.
     */
    private Utils() {
        // does nothing.
    }

    /**
     * performs a simple check that the file is real and readable.
     * @param aFile the file to check
     * @param aParamName the name of the input param - used for error reporting.
     * @throws IOException if the file was null or not readable.
     */
    public static void checkFile(final File aFile, final String aParamName)
             throws IOException {
        if (aFile == null) {
            throw new FileNotFoundException(aParamName
                    + " is mandatory");
        }

        if (!aFile.exists()) {
            throw new FileNotFoundException(aFile
                    + " does not exist.");
        }

        if (!aFile.canRead()) {
            throw new IOException("Unable to read from '"
                    + aFile + "' while processing value for param "
                    + aParamName);
        }

    }

    /**
     * extract an input stream from the supplied resource file. The resource is
     * presumed to be somewhere on the classpath for this app.
     * @param aResourcePath the path to the resource we need the
     *        actual system path for. Must not be empty or null.
     * @return an input stream pointing at the named resource.
     * @throws IOException if the resource path was not readable.
     */
    public static InputStream extractAsInputStream(final String aResourcePath)
            throws IOException {

        assert aResourcePath != null : "The supplied path was null";
        assert !"".equals(aResourcePath) : "The supplied path was empty";

        final ClassLoader l = Utils.class.getClassLoader();
        final InputStream res = l.getResourceAsStream(aResourcePath);
        if (res == null) {
            throw new FileNotFoundException(
                    "could not find resource at " + aResourcePath);
        }
        return res;
    }

    /**
     * Generate a yyyy-MM-dd date based on now less the number of hours
     * to offset.
     * @param anOffset the number of hours to subtract from now.
     * @return a yyyy-MM-dd formatted string representing now less the offset.
     */
    public static String formatDateBasedOnOffset(final String anOffset) {
        assert anOffset != null : "offset supplied must not be null";
        final int hours = Integer.parseInt(anOffset);
        assert hours > 0 : "offset supplied must be positive";

        final Calendar c = Calendar.getInstance();
        c.add(Calendar.HOUR, -hours);

        final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd",
                Locale.getDefault());
        return df.format(c.getTime());
    }

}
