////////////////////////////////////////////////////////////////////////////////
//
//                  ObjectLab is sponsoring QALab
//
// Based in London, we are world leaders in the design and development
// of bespoke applications for the Securities Financing markets.
//
// <a href="http://www.objectlab.co.uk/open">Click here to learn more</a>
//           ___  _     _           _   _          _
//          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
//         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
//         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
//          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
//                   |__/
//
//                   http://www.ObjectLab.co.uk
// ---------------------------------------------------------------------------
//
//QALab is released under the GNU General Public License.
//
//QALab: Collects QA Statistics from your build over time.
//2005+, ObjectLab Ltd
//
//This library is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public
//License as published by the Free Software Foundation; either
//version 2.1 of the License, or (at your option) any later version.
//
//This library is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//General Public License for more details.
//
//You should have received a copy of the GNU General Public
//License along with this library; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
////////////////////////////////////////////////////////////////////////////////
package net.objectlab.qalab.m2;

import java.io.File;

/**
 * Goal that handles the Checkstyle statistics into qalab.xml, it should not request any tailoring if
 * you use the Maven default for Checkstyle.
 * 
 * @author Benoit Xhenseval
 * @goal merge-checkstyle
 * @phase site
 */
public class CheckstyleStatMergeMojo extends BuildStatMergeMojo {

    // ~ Instance fields -------------------------------------------------------
    /**
     * The file the whose values will be incorporated in the qalab.xml. This
     * file will have been generated by checkstyle, or pmd etc.
     * 
     * @parameter expression="${project.build.directory}/checkstyle-result.xml"
     */
    private File inputFile = null;

    /**
     * The fully qualified class name for the handler for the given statistics.
     * <ul>
     * The built-in handlers are:
     * <li>net.objectlab.qalab.parser.CheckstyleStatMerge</li>
     * <li>net.objectlab.qalab.parser.PMDStatMerge</li>
     * <li>net.objectlab.qalab.parser.FindBugsStatMerge</li>
     * <li>net.objectlab.qalab.parser.SimianStatMerge</li>
     * </ul>
     * 
     * @parameter default-value="net.objectlab.qalab.parser.CheckstyleStatMerge"
     */
    private String handler;

    public String getHandler() {
        return handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public File getInputFile() {
        return inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }
}
/*
 *                   ObjectLab is sponsoring QALab
 * 
 * Based in London, we are world leaders in the design and development 
 * of bespoke applications for the securities financing markets.
 * 
 * <a href="http://www.objectlab.co.uk/open">Click here to learn more about us</a>
 *           ___  _     _           _   _          _
 *          / _ \| |__ (_) ___  ___| |_| |    __ _| |__
 *         | | | | '_ \| |/ _ \/ __| __| |   / _` | '_ \
 *         | |_| | |_) | |  __/ (__| |_| |__| (_| | |_) |
 *          \___/|_.__// |\___|\___|\__|_____\__,_|_.__/
 *                   |__/
 *
 *                     www.ObjectLab.co.uk
 */
