/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.m2.util.XmlTransformer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class MainReport
extends AbstractMavenReport {
    private File inputFile = null;
    private String moversBundledXsl = null;
    private String outputDirectory;
    private String types = "checkstyle,pmd,pmd-cpd,findbugs,simian,cobertura-line,cobertura-branch";
    private InputStream theXmlStream = null;
    private File styleSheet = null;
    private InputStream theStyleSheetStream = null;
    private String startTimeHoursOffset = "48";
    private String theOffset;
    private SiteRenderer siteRenderer;
    private MavenProject project;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final void executeReport(Locale aLocale) throws MavenReportException {
        File output;
        this.validate();
        File outdir = new File(this.getOutputDirectory());
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        if (!$assertionsDisabled && !outdir.isDirectory()) {
            throw new AssertionError((Object)"the output directory was not a directory");
        }
        try {
            output = File.createTempFile("qalab", null, outdir);
            if (!$assertionsDisabled && output == null) {
                throw new AssertionError((Object)"the temp file is null.");
            }
        }
        catch (IOException ioex) {
            throw new MavenReportException("could not create temp file.", (Exception)ioex);
        }
        XmlTransformer t = new XmlTransformer(this.theXmlStream, this.theStyleSheetStream, output);
        t.addParameter("targetdir", this.getOutputDirectory());
        t.addParameter("type", this.types);
        t.addParameter("offset", this.theOffset);
        try {
            t.transform();
        }
        catch (TransformerException tex) {
            throw new MavenReportException("transformation failed.", (Exception)tex);
        }
        output.deleteOnExit();
    }

    public final String getOutputName() {
        return "qalab/index";
    }

    protected final String getOutputDirectory() {
        return this.outputDirectory;
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public final String getName(Locale aLocale) {
        return MainReport.getBundle(aLocale).getString("report.qalab.name");
    }

    public final String getDescription(Locale aLocale) {
        return MainReport.getBundle(aLocale).getString("report.qalab.description");
    }

    public final boolean isExternalReport() {
        return true;
    }

    private static ResourceBundle getBundle(Locale aLocale) {
        return ResourceBundle.getBundle("qalab-report", aLocale, MainReport.class.getClassLoader());
    }

    private void validate() throws MavenReportException {
        try {
            Utils.checkFile(this.inputFile, "inputFile");
            this.theXmlStream = new FileInputStream(this.inputFile);
        }
        catch (IOException ioex) {
            throw new MavenReportException(ioex.getMessage(), (Exception)ioex);
        }
        if (this.styleSheet == null) {
            try {
                this.theStyleSheetStream = Utils.extractAsInputStream(this.moversBundledXsl);
            }
            catch (IOException ioex) {
                throw new MavenReportException("Could not find the default stylesheet. " + ioex.getMessage(), (Exception)ioex);
            }
        }
        try {
            Utils.checkFile(this.styleSheet, "styleSheet");
            this.theStyleSheetStream = new FileInputStream(this.styleSheet);
        }
        catch (IOException ioex) {
            throw new MavenReportException(ioex.getMessage(), (Exception)ioex);
        }
        this.theOffset = Utils.formatDateBasedOnOffset(this.startTimeHoursOffset);
    }

    static {
        $assertionsDisabled = !MainReport.class.desiredAssertionStatus();
    }
}

