/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.HotMethod;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.threads.AbstractLifecycleEventLoop;
import net.openhft.chronicle.threads.CoreEventLoop;
import net.openhft.chronicle.threads.EventHandlers;
import net.openhft.chronicle.threads.ExceptionHandlerStrategy;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.internal.EventLoopUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MediumEventLoop
extends AbstractLifecycleEventLoop
implements CoreEventLoop,
Runnable,
Closeable {
    public static final Set<HandlerPriority> ALLOWED_PRIORITIES = Collections.unmodifiableSet(EnumSet.of(HandlerPriority.HIGH, HandlerPriority.MEDIUM));
    public static final int NO_CPU = -1;
    protected static final EventHandler[] NO_EVENT_HANDLERS = new EventHandler[0];
    protected static final long FINISHED = 0x7FFFFFFFFFFFFFFEL;
    @Nullable
    protected final EventLoop parent;
    @NotNull
    protected final ExecutorService service;
    protected final List<EventHandler> mediumHandlers = new CopyOnWriteArrayList<EventHandler>();
    protected final AtomicReference<EventHandler> newHandler = new AtomicReference();
    protected final Pauser pauser;
    protected final boolean daemon;
    private final String binding;
    @NotNull
    protected EventHandler[] mediumHandlersArray = NO_EVENT_HANDLERS;
    protected EventHandler highHandler = EventHandlers.NOOP;
    @Deprecated
    protected volatile long loopStartMS;
    protected volatile long loopStartNS;
    @Nullable
    protected volatile Thread thread = null;
    @NotNull
    protected final ExceptionHandlerStrategy exceptionThrownByHandler = ExceptionHandlerStrategy.strategy();

    public MediumEventLoop(@Nullable EventLoop parent, String name, Pauser pauser, boolean daemon, String binding) {
        super(name);
        this.parent = parent;
        this.pauser = pauser;
        this.daemon = daemon;
        this.binding = binding;
        this.loopStartMS = Long.MAX_VALUE;
        this.loopStartNS = Long.MAX_VALUE;
        this.service = Executors.newSingleThreadExecutor(new NamedThreadFactory(name, daemon, null, true));
        this.disableThreadSafetyCheck(true);
    }

    public static void closeAll(@NotNull List<EventHandler> handlers) {
        Closeable.closeQuietly(handlers);
    }

    private static void clearUsedByThread(@NotNull EventHandler handler) {
        if (handler instanceof AbstractCloseable) {
            ((AbstractCloseable)handler).clearUsedByThread();
        }
    }

    static String hasBeen(String offendingProperty) {
        return "MediumEventLoop has been " + offendingProperty;
    }

    protected static void removeHandler(EventHandler handler, @NotNull List<EventHandler> handlers) {
        block2: {
            try {
                handlers.remove(handler);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                if (handlers.isEmpty()) break block2;
                throw e2;
            }
        }
        Threads.loopFinishedQuietly(handler);
        Closeable.closeQuietly((Object)handler);
    }

    @Override
    @Nullable
    public Thread thread() {
        return this.thread;
    }

    @NotNull
    public String toString() {
        return "MediumEventLoop{name='" + this.name + '\'' + ", parent=" + this.parent + ", service=" + this.service + ", highHandler=" + this.highHandler + ", mediumHandlers=" + this.mediumHandlers + ", newHandler=" + this.newHandler + ", pauser=" + this.pauser + '}';
    }

    @Override
    protected void performStart() {
        block2: {
            try {
                this.service.submit(this);
            }
            catch (RejectedExecutionException e) {
                if (this.isClosed()) break block2;
                this.closeAll();
                throw e;
            }
        }
    }

    public void unpause() {
        this.pauser.unpause();
    }

    @Override
    protected void performStopFromNew() {
        this.stopEventLoopThread();
        this.loopFinishedAllHandlers();
    }

    @Override
    protected void performStopFromStarted() {
        this.stopEventLoopThread();
    }

    private void stopEventLoopThread() {
        this.unpause();
        this.shutdownService();
    }

    public void addHandler(@NotNull EventHandler handler) {
        this.throwExceptionIfClosed();
        HandlerPriority priority = handler.priority().alias();
        if (DEBUG_ADDING_HANDLERS) {
            Jvm.startup().on(this.getClass(), "Adding " + priority + " " + handler + " to " + this.name);
        }
        if (!ALLOWED_PRIORITIES.contains(priority)) {
            if (handler.priority() == HandlerPriority.MONITOR) {
                Jvm.warn().on(this.getClass(), "Ignoring " + handler.getClass());
            }
            throw new IllegalStateException(this.name() + ": Unexpected priority " + priority + " for " + handler);
        }
        if (this.thread == null || this.thread == Thread.currentThread()) {
            this.addNewHandler(handler);
            return;
        }
        do {
            if (this.isStopped()) {
                return;
            }
            this.pauser.unpause();
            this.checkInterruptedAddingNewHandler();
        } while (!this.newHandler.compareAndSet(null, handler));
    }

    void checkInterruptedAddingNewHandler() {
        if (Thread.currentThread().isInterrupted()) {
            throw new IllegalStateException(MediumEventLoop.hasBeen("interrupted. Handler in newHandler was not accepted before."));
        }
    }

    @Override
    public long loopStartMS() {
        return this.loopStartMS;
    }

    @Override
    public long loopStartNS() {
        return this.loopStartNS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @HotMethod
    public void run() {
        try {
            try (AffinityLock lock = AffinityLock.acquireLock((String)this.binding);){
                this.thread = Thread.currentThread();
                if (this.thread == null) {
                    throw new NullPointerException();
                }
                this.loopStartedAllHandlers();
                this.runLoop();
            }
            catch (ClosedIllegalStateException e) {
                if (!this.isClosing()) {
                    Jvm.rethrow((Throwable)e);
                }
            }
            finally {
                this.loopFinishedAllHandlers();
                this.loopStartMS = 0x7FFFFFFFFFFFFFFEL;
                this.loopStartNS = 0x7FFFFFFFFFFFFFFEL;
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), MediumEventLoop.hasBeen("terminated due to exception"), e);
        }
    }

    protected void loopStartedAllHandlers() {
        this.highHandler.loopStarted();
        if (!this.mediumHandlers.isEmpty()) {
            this.mediumHandlers.forEach(EventHandler::loopStarted);
        }
    }

    protected void loopFinishedAllHandlers() {
        Threads.loopFinishedQuietly(this.highHandler);
        if (!this.mediumHandlers.isEmpty()) {
            this.mediumHandlers.forEach(Threads::loopFinishedQuietly);
        }
        Optional.ofNullable(this.newHandler.get()).ifPresent(eventHandler -> {
            Jvm.warn().on(this.getClass(), "Handler in newHandler was not accepted before loop finished " + eventHandler);
            Threads.loopFinishedQuietly(eventHandler);
        });
    }

    private void runLoop() {
        int acceptHandlerModCount = EventLoopUtil.ACCEPT_HANDLER_MOD_COUNT;
        long lastTimerNS = 0L;
        while (this.isStarted()) {
            boolean busy;
            this.throwExceptionIfClosed();
            this.loopStartMS = System.currentTimeMillis();
            this.loopStartNS = System.nanoTime();
            boolean bl = busy = this.highHandler == EventHandlers.NOOP ? this.runAllMediumHandler() : this.runAllHandlers();
            if (lastTimerNS + this.timerIntervalMS() * 1000000L < this.loopStartNS) {
                lastTimerNS = this.loopStartNS;
                this.runTimerHandlers();
            }
            if (busy) {
                this.pauser.reset();
                if (!EventLoopUtil.IS_ACCEPT_HANDLER_MOD_COUNT || --acceptHandlerModCount > 0) continue;
                this.acceptNewHandlers();
                acceptHandlerModCount = EventLoopUtil.ACCEPT_HANDLER_MOD_COUNT;
                continue;
            }
            if (this.acceptNewHandlers()) continue;
            this.runDaemonHandlers();
            this.loopStartMS = Long.MAX_VALUE;
            this.loopStartNS = Long.MAX_VALUE;
            this.pauser.pause();
        }
    }

    protected long timerIntervalMS() {
        return 0x3FFFFFFFFFFFFFFFL;
    }

    protected void runTimerHandlers() {
    }

    protected void runDaemonHandlers() {
    }

    private void closeAll() {
        this.closeAllHandlers();
        Jvm.debug().on(this.getClass(), "Remaining handlers");
        this.dumpRunningHandlers();
    }

    private boolean runAllMediumHandler() {
        boolean busy = false;
        EventHandler[] handlers = this.mediumHandlersArray;
        try {
            switch (handlers.length) {
                default: {
                    for (int i = handlers.length - 1; i >= 4; --i) {
                        try {
                            busy |= handlers[i].action();
                            continue;
                        }
                        catch (Exception e) {
                            this.handleExceptionMediumHandler(handlers[i], e);
                        }
                    }
                }
                case 4: {
                    try {
                        busy |= handlers[3].action();
                    }
                    catch (Exception e) {
                        this.handleExceptionMediumHandler(handlers[3], e);
                    }
                }
                case 3: {
                    try {
                        busy |= handlers[2].action();
                    }
                    catch (Exception e) {
                        this.handleExceptionMediumHandler(handlers[2], e);
                    }
                }
                case 2: {
                    try {
                        busy |= handlers[1].action();
                    }
                    catch (Exception e) {
                        this.handleExceptionMediumHandler(handlers[1], e);
                    }
                }
                case 1: {
                    try {
                        busy |= handlers[0].action();
                        break;
                    }
                    catch (Exception e) {
                        this.handleExceptionMediumHandler(handlers[0], e);
                    }
                }
                case 0: 
            }
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
        return busy;
    }

    protected boolean runAllHandlers() {
        boolean busy = false;
        EventHandler[] handlers = this.mediumHandlersArray;
        try {
            busy |= this.callHighHandler();
            switch (handlers.length) {
                default: {
                    for (int i = handlers.length - 1; i >= 4; --i) {
                        busy |= this.callHighHandler();
                        try {
                            busy |= handlers[i].action();
                            continue;
                        }
                        catch (Exception e) {
                            this.handleExceptionMediumHandler(handlers[i], e);
                        }
                    }
                }
                case 4: {
                    busy |= this.callHighHandler();
                    try {
                        busy |= handlers[3].action();
                    }
                    catch (Exception e) {
                        this.handleExceptionMediumHandler(handlers[3], e);
                    }
                }
                case 3: {
                    busy |= this.callHighHandler();
                    try {
                        busy |= handlers[2].action();
                    }
                    catch (Exception e) {
                        this.handleExceptionMediumHandler(handlers[2], e);
                    }
                }
                case 2: {
                    busy |= this.callHighHandler();
                    try {
                        busy |= handlers[1].action();
                    }
                    catch (Exception e) {
                        this.handleExceptionMediumHandler(handlers[1], e);
                    }
                }
                case 1: {
                    busy |= this.callHighHandler();
                    try {
                        busy |= handlers[0].action();
                        break;
                    }
                    catch (Exception e) {
                        this.handleExceptionMediumHandler(handlers[0], e);
                    }
                }
                case 0: 
            }
            busy |= this.callHighHandler();
        }
        catch (Throwable e) {
            Jvm.warn().on(this.getClass(), e);
        }
        return busy;
    }

    private boolean callHighHandler() {
        try {
            return this.highHandler.action();
        }
        catch (Exception e) {
            if (this.exceptionThrownByHandler.handle(this, this.highHandler, e)) {
                Threads.loopFinishedQuietly(this.highHandler);
                Closeable.closeQuietly((Object)this.highHandler);
                this.highHandler = EventHandlers.NOOP;
            }
            return true;
        }
    }

    private void handleExceptionMediumHandler(EventHandler handler, Throwable t) {
        if (this.exceptionThrownByHandler.handle(this, handler, t)) {
            MediumEventLoop.removeHandler(handler, this.mediumHandlers);
            this.updateMediumHandlersArray();
        }
    }

    protected synchronized void updateMediumHandlersArray() {
        this.mediumHandlersArray = this.mediumHandlers.toArray(NO_EVENT_HANDLERS);
    }

    @HotMethod
    private boolean acceptNewHandlers() {
        EventHandler handler = this.newHandler.getAndSet(null);
        if (handler != null) {
            this.addNewHandler(handler);
            return true;
        }
        return false;
    }

    protected void addNewHandler(@NotNull EventHandler handler) {
        HandlerPriority t1 = handler.priority();
        switch (t1.alias()) {
            case HIGH: {
                if (this.updateHighHandler(handler)) break;
                Jvm.warn().on(this.getClass(), "Only one high handler supported was " + this.highHandler + ", treating " + handler + " as MEDIUM");
            }
            case REPLICATION: 
            case CONCURRENT: 
            case DAEMON: 
            case MEDIUM: {
                if (this.mediumHandlers.contains(handler)) break;
                MediumEventLoop.clearUsedByThread(handler);
                this.mediumHandlers.add(handler);
                this.updateMediumHandlersArray();
                handler.eventLoop((EventLoop)(this.parent != null ? this.parent : this));
                break;
            }
            case MONITOR: {
                if (this.parent != null) {
                    Jvm.warn().on(this.getClass(), "Handler " + handler.getClass() + " ignored");
                    return;
                }
            }
            default: {
                throw new IllegalArgumentException("Cannot add a " + handler.priority() + " task to a busy waiting thread");
            }
        }
        handler.eventLoop((EventLoop)(this.parent != null ? this.parent : this));
        if (this.thread != null) {
            handler.loopStarted();
        }
    }

    protected synchronized boolean updateHighHandler(@NotNull EventHandler handler) {
        if (this.highHandler == EventHandlers.NOOP || this.highHandler == handler) {
            this.highHandler = handler;
            return true;
        }
        return false;
    }

    @Override
    public void dumpRunningState(@NotNull String message, @NotNull BooleanSupplier finalCheck) {
        Thread threadSnapshot = this.thread;
        if (threadSnapshot == null || !Jvm.isPerfEnabled(this.getClass())) {
            return;
        }
        StringBuilder out = new StringBuilder(message);
        int messageIndex = out.length();
        long startTimeNanos = System.nanoTime();
        Jvm.trimStackTrace((StringBuilder)out, (StackTraceElement[])threadSnapshot.getStackTrace());
        if (!finalCheck.getAsBoolean()) {
            long timeToTakeStackTraceMillis = (System.nanoTime() - startTimeNanos) / 1000000L;
            out.setLength(messageIndex);
            out.append(" An accurate stack trace could not be determined (capturing the stack trace took " + timeToTakeStackTraceMillis + "ms)");
        }
        Jvm.perf().on(this.getClass(), out.toString());
    }

    public int nonDaemonHandlerCount() {
        return (this.highHandler == EventHandlers.NOOP ? 0 : 1) + this.mediumHandlers.size();
    }

    public int handlerCount() {
        return this.nonDaemonHandlerCount();
    }

    protected void closeAllHandlers() {
        Closeable.closeQuietly((Object)this.highHandler);
        MediumEventLoop.closeAll(this.mediumHandlers);
        Optional.ofNullable(this.newHandler.get()).ifPresent(eventHandler -> {
            Jvm.warn().on(this.getClass(), "Handler in newHandler was not accepted before close " + eventHandler);
            Closeable.closeQuietly((Object)eventHandler);
        });
    }

    public void dumpRunningHandlers() {
        int handlerCount = this.handlerCount();
        if (handlerCount <= 0) {
            return;
        }
        List<EventHandler> collect = Stream.of(Collections.singletonList(this.highHandler), this.mediumHandlers).flatMap(Collection::stream).filter(e -> e != EventHandlers.NOOP).filter(Closeable.class::isInstance).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        Jvm.debug().on(this.getClass(), "Handlers still running after being closed, handlerCount=" + handlerCount);
        collect.forEach(h -> Jvm.debug().on(this.getClass(), "\t" + h));
    }

    public boolean isAlive() {
        Thread threadSnapshot = this.thread;
        return threadSnapshot != null && threadSnapshot.isAlive();
    }

    @Override
    protected void performClose() {
        try {
            super.performClose();
        }
        finally {
            this.closeAllHandlers();
            this.highHandler = EventHandlers.NOOP;
            this.mediumHandlers.clear();
            this.updateMediumHandlersArray();
            this.newHandler.set(null);
        }
    }

    private void shutdownService() {
        LockSupport.unpark(this.thread);
        Threads.shutdown(this.service, this.daemon);
        if (this.thread != null && this.thread != Thread.currentThread()) {
            long startTimeMillis;
            long waitUntilMs = startTimeMillis = System.currentTimeMillis();
            this.thread.interrupt();
            for (int i = 1; i <= 50 && this.loopStartNS != 0x7FFFFFFFFFFFFFFEL; ++i) {
                waitUntilMs += (long)i;
                while (System.currentTimeMillis() < waitUntilMs) {
                    Jvm.pause((long)i);
                }
                if (i != 35 && i != 50) continue;
                StringBuilder sb = new StringBuilder();
                long ms = System.currentTimeMillis() - startTimeMillis;
                sb.append(this.name).append(": Shutting down thread is executing after ").append(ms).append("ms ").append(this.thread).append(", handlerCount=").append(this.nonDaemonHandlerCount());
                Jvm.trimStackTrace((StringBuilder)sb, (StackTraceElement[])this.thread.getStackTrace());
                Jvm.warn().on(this.getClass(), sb.toString());
                this.dumpRunningHandlers();
            }
        }
    }
}

