/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import net.pwall.json.JSONArray;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONException;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.JSONZero;
import net.pwall.util.CharMapper;
import net.pwall.util.CharUnmapper;
import net.pwall.util.ParseText;
import net.pwall.util.ReaderBuffer;
import net.pwall.util.Strings;

public class JSON {
    public static final String INVALID_CHAR_SEQ = "Invalid JSON character sequence";
    public static final String EXCESS_CHARS = "Excess characters after JSON value";
    public static final String ILLEGAL_KEY = "Illegal key in JSON object";
    public static final String DUPLICATE_KEY = "Duplicate key in JSON object";
    public static final String MISSING_COLON = "Missing colon in JSON object";
    public static final String MISSING_CLOSING_BRACE = "Missing closing brace in JSON object";
    public static final String MISSING_CLOSING_BRACKET = "Missing closing bracket in JSON array";
    public static final String ILLEGAL_NUMBER = "Illegal JSON number";
    public static final String ILLEGAL_SYNTAX = "Illegal JSON syntax";
    public static final String ILLEGAL_STRING_TERM = "Unterminated JSON string";
    public static final String ILLEGAL_STRING_CHAR = "Illegal character in JSON string";
    public static final String ILLEGAL_STRING_UNICODE = "Illegal Unicode sequence in JSON string";
    public static final String ILLEGAL_STRING_ESCAPE = "Illegal escape sequence in JSON string";
    public static final String NOT_A_STRING = "Not a JSON string";
    public static final String NOT_A_NUMBER = "Not a JSON number";
    public static final String NOT_A_BOOLEAN = "Not a JSON boolean";
    public static final String NOT_AN_ARRAY = "Not a JSON array";
    public static final String NOT_AN_OBJECT = "Not a JSON object";
    public static final CharMapper charMapper = codePoint -> {
        if (codePoint == 34) {
            return "\\\"";
        }
        if (codePoint == 92) {
            return "\\\\";
        }
        if (codePoint >= 32 && codePoint < 127) {
            return null;
        }
        if (codePoint == 8) {
            return "\\b";
        }
        if (codePoint == 12) {
            return "\\f";
        }
        if (codePoint == 10) {
            return "\\n";
        }
        if (codePoint == 13) {
            return "\\r";
        }
        if (codePoint == 9) {
            return "\\t";
        }
        StringBuilder sb = new StringBuilder("\\u");
        try {
            if (Character.isBmpCodePoint(codePoint)) {
                Strings.appendHex((Appendable)sb, (char)((char)codePoint));
            } else {
                Strings.appendHex((Appendable)sb, (char)Character.highSurrogate(codePoint));
                sb.append("\\u");
                Strings.appendHex((Appendable)sb, (char)Character.lowSurrogate(codePoint));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    };
    public static final CharUnmapper charUnmapper = new CharUnmapper(){

        public boolean isEscape(CharSequence s, int offset) {
            return s.charAt(offset) == '\\';
        }

        public int unmap(StringBuilder sb, CharSequence s, int offset) {
            if (offset + 1 >= s.length()) {
                throw new JSONException(JSON.INVALID_CHAR_SEQ);
            }
            char ch = s.charAt(offset + 1);
            if (ch == '\"') {
                sb.append('\"');
                return 2;
            }
            if (ch == '\\') {
                sb.append('\\');
                return 2;
            }
            if (ch == '/') {
                sb.append('/');
                return 2;
            }
            if (ch == 'b') {
                sb.append('\b');
                return 2;
            }
            if (ch == 'f') {
                sb.append('\f');
                return 2;
            }
            if (ch == 'n') {
                sb.append('\n');
                return 2;
            }
            if (ch == 'r') {
                sb.append('\r');
                return 2;
            }
            if (ch == 't') {
                sb.append('\t');
                return 2;
            }
            if (ch == 'u' && offset + 6 <= s.length()) {
                int n = Strings.convertHexToInt((CharSequence)s, (int)(offset + 2), (int)(offset + 6));
                sb.append((char)n);
                return 6;
            }
            throw new JSONException(JSON.INVALID_CHAR_SEQ);
        }
    };

    private JSON() throws IllegalAccessException {
        throw new IllegalAccessException("Attempt to instantiate JSON");
    }

    public static JSONValue parse(File f) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            JSONValue jSONValue = JSON.parse(is);
            return jSONValue;
        }
    }

    public static JSONArray parseArray(File f) throws IOException {
        return (JSONArray)JSON.parse(f);
    }

    public static JSONObject parseObject(File f) throws IOException {
        return (JSONObject)JSON.parse(f);
    }

    public static JSONValue parse(File f, Charset charSet) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            JSONValue jSONValue = JSON.parse((InputStream)is, charSet);
            return jSONValue;
        }
    }

    public static JSONArray parseArray(File f, Charset charSet) throws IOException {
        return (JSONArray)JSON.parse(f, charSet);
    }

    public static JSONObject parseObject(File f, Charset charSet) throws IOException {
        return (JSONObject)JSON.parse(f, charSet);
    }

    public static JSONValue parse(File f, String csName) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            JSONValue jSONValue = JSON.parse((InputStream)is, csName);
            return jSONValue;
        }
    }

    public static JSONArray parseArray(File f, String csName) throws IOException {
        return (JSONArray)JSON.parse(f, csName);
    }

    public static JSONObject parseObject(File f, String csName) throws IOException {
        return (JSONObject)JSON.parse(f, csName);
    }

    public static JSONValue parse(InputStream is) throws IOException {
        try (InputStreamReader rdr = new InputStreamReader(is);){
            JSONValue jSONValue = JSON.parse(rdr);
            return jSONValue;
        }
    }

    public static JSONArray parseArray(InputStream is) throws IOException {
        return (JSONArray)JSON.parse(is);
    }

    public static JSONObject parseObject(InputStream is) throws IOException {
        return (JSONObject)JSON.parse(is);
    }

    public static JSONValue parse(InputStream is, Charset charSet) throws IOException {
        try (InputStreamReader rdr = new InputStreamReader(is, charSet);){
            JSONValue jSONValue = JSON.parse(rdr);
            return jSONValue;
        }
    }

    public static JSONArray parseArray(InputStream is, Charset charSet) throws IOException {
        return (JSONArray)JSON.parse(is, charSet);
    }

    public static JSONObject parseObject(InputStream is, Charset charSet) throws IOException {
        return (JSONObject)JSON.parse(is, charSet);
    }

    public static JSONValue parse(InputStream is, String csName) throws IOException {
        try (InputStreamReader rdr = new InputStreamReader(is, csName);){
            JSONValue jSONValue = JSON.parse(rdr);
            return jSONValue;
        }
    }

    public static JSONArray parseArray(InputStream is, String csName) throws IOException {
        return (JSONArray)JSON.parse(is, csName);
    }

    public static JSONObject parseObject(InputStream is, String csName) throws IOException {
        return (JSONObject)JSON.parse(is, csName);
    }

    public static JSONValue parse(Reader rdr) throws IOException {
        return JSON.parse((CharSequence)new ReaderBuffer(rdr));
    }

    public static JSONArray parseArray(Reader rdr) throws IOException {
        return (JSONArray)JSON.parse(rdr);
    }

    public static JSONObject parseObject(Reader rdr) throws IOException {
        return (JSONObject)JSON.parse(rdr);
    }

    public static JSONValue parse(CharSequence cs) {
        ParseText p = new ParseText(cs);
        JSONValue result = JSON.parse(p);
        if (!p.skipSpaces().isExhausted()) {
            throw new JSONException(EXCESS_CHARS);
        }
        return result;
    }

    public static JSONArray parseArray(CharSequence cs) {
        return (JSONArray)JSON.parse(cs);
    }

    public static JSONObject parseObject(CharSequence cs) {
        return (JSONObject)JSON.parse(cs);
    }

    public static JSONValue parse(ParseText p) {
        p.skipSpaces();
        if (p.match('{')) {
            JSONObject object = new JSONObject();
            if (!p.skipSpaces().match('}')) {
                while (true) {
                    if (!p.match('\"')) {
                        throw new JSONException(ILLEGAL_KEY);
                    }
                    String key = JSON.decodeString(p);
                    if (object.containsKey(key)) {
                        throw new JSONException(DUPLICATE_KEY);
                    }
                    if (!p.skipSpaces().match(':')) {
                        throw new JSONException(MISSING_COLON);
                    }
                    object.put(key, JSON.parse(p));
                    if (!p.skipSpaces().match(',')) break;
                    p.skipSpaces();
                }
                if (!p.match('}')) {
                    throw new JSONException(MISSING_CLOSING_BRACE);
                }
            }
            return object;
        }
        if (p.match('[')) {
            JSONArray array = new JSONArray();
            if (!p.skipSpaces().match(']')) {
                do {
                    array.add(JSON.parse(p));
                } while (p.skipSpaces().match(','));
                if (!p.match(']')) {
                    throw new JSONException(MISSING_CLOSING_BRACKET);
                }
            }
            return array;
        }
        if (p.match('\"')) {
            return new JSONString(JSON.decodeString(p));
        }
        int numberStart = p.getIndex();
        if (p.match('-')) {
            // empty if block
        }
        if (p.matchDec()) {
            boolean zero = false;
            if (p.getResultChar() == '0') {
                if (p.getResultLength() > 1) {
                    throw new JSONException(ILLEGAL_NUMBER);
                }
                zero = true;
            }
            boolean floating = false;
            if (p.match('.')) {
                floating = true;
                if (!p.matchDec()) {
                    throw new JSONException(ILLEGAL_NUMBER);
                }
            }
            if (p.matchIgnoreCase('e')) {
                floating = true;
                if (p.match('+') || p.match('-')) {
                    // empty if block
                }
                if (!p.matchDec()) {
                    throw new JSONException(ILLEGAL_NUMBER);
                }
            }
            if (floating) {
                return JSONDouble.valueOf(p.getString(numberStart, p.getIndex()));
            }
            if (zero) {
                return JSONZero.ZERO;
            }
            long longValue = Long.parseLong(p.getString(numberStart, p.getIndex()));
            int intValue = (int)longValue;
            return (long)intValue == longValue ? JSONInteger.valueOf(intValue) : JSONLong.valueOf(longValue);
        }
        if (p.getIndex() > numberStart) {
            throw new JSONException(ILLEGAL_NUMBER);
        }
        if (p.matchName((CharSequence)"true")) {
            return JSONBoolean.TRUE;
        }
        if (p.matchName((CharSequence)"false")) {
            return JSONBoolean.FALSE;
        }
        if (p.matchName((CharSequence)"null")) {
            return null;
        }
        throw new JSONException(ILLEGAL_SYNTAX);
    }

    public static JSONArray parseArray(ParseText p) {
        return (JSONArray)JSON.parse(p);
    }

    public static JSONObject parseObject(ParseText p) {
        return (JSONObject)JSON.parse(p);
    }

    private static String decodeString(ParseText p) {
        int start;
        block28: {
            char ch;
            start = p.getIndex();
            do {
                if (p.isExhausted()) {
                    throw new JSONException(ILLEGAL_STRING_TERM);
                }
                ch = p.getChar();
                if (ch == '\"') {
                    return p.getString(start, p.getStart());
                }
                if (ch == '\\') break block28;
            } while (ch >= ' ');
            throw new JSONException(ILLEGAL_STRING_CHAR);
        }
        StringBuilder sb = new StringBuilder(p.getString(start, p.getStart()));
        block1: while (true) {
            if (p.isExhausted()) {
                throw new JSONException(ILLEGAL_STRING_TERM);
            }
            char ch = p.getChar();
            if (ch == '\"') {
                sb.append('\"');
            } else if (ch == '\\') {
                sb.append('\\');
            } else if (ch == '/') {
                sb.append('/');
            } else if (ch == 'b') {
                sb.append('\b');
            } else if (ch == 'f') {
                sb.append('\f');
            } else if (ch == 'n') {
                sb.append('\n');
            } else if (ch == 'r') {
                sb.append('\r');
            } else if (ch == 't') {
                sb.append('\t');
            } else if (ch == 'u') {
                if (!p.matchHexFixed(4)) {
                    throw new JSONException(ILLEGAL_STRING_UNICODE);
                }
                sb.append((char)p.getResultHexInt());
            } else {
                throw new JSONException(ILLEGAL_STRING_ESCAPE);
            }
            while (true) {
                if (p.isExhausted()) {
                    throw new JSONException(ILLEGAL_STRING_TERM);
                }
                ch = p.getChar();
                if (ch == '\"') {
                    return sb.toString();
                }
                if (ch == '\\') continue block1;
                if (ch < ' ') {
                    throw new JSONException(ILLEGAL_STRING_CHAR);
                }
                sb.append(ch);
            }
            break;
        }
    }

    public static String toJSON(JSONValue value) {
        return value == null ? "null" : value.toJSON();
    }

    public static void appendJSON(Appendable a, JSONValue value) throws IOException {
        if (value == null) {
            a.append("null");
        } else {
            value.appendJSON(a);
        }
    }

    public static String getString(JSONValue value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof JSONString)) {
            throw new JSONException(NOT_A_STRING);
        }
        return ((JSONString)value).toString();
    }

    public static int getInt(JSONValue value) {
        if (value == null) {
            return 0;
        }
        if (!(value instanceof Number)) {
            throw new JSONException(NOT_A_NUMBER);
        }
        return ((Number)((Object)value)).intValue();
    }

    public static long getLong(JSONValue value) {
        if (value == null) {
            return 0L;
        }
        if (!(value instanceof Number)) {
            throw new JSONException(NOT_A_NUMBER);
        }
        return ((Number)((Object)value)).longValue();
    }

    public static float getFloat(JSONValue value) {
        if (value == null) {
            return 0.0f;
        }
        if (!(value instanceof Number)) {
            throw new JSONException(NOT_A_NUMBER);
        }
        return ((Number)((Object)value)).floatValue();
    }

    public static double getDouble(JSONValue value) {
        if (value == null) {
            return 0.0;
        }
        if (!(value instanceof Number)) {
            throw new JSONException(NOT_A_NUMBER);
        }
        return ((Number)((Object)value)).doubleValue();
    }

    public static boolean getBoolean(JSONValue value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof JSONBoolean)) {
            throw new JSONException(NOT_A_BOOLEAN);
        }
        return ((JSONBoolean)value).booleanValue();
    }

    public static JSONArray getArray(JSONValue value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof JSONArray)) {
            throw new JSONException(NOT_AN_ARRAY);
        }
        return (JSONArray)value;
    }

    public static JSONObject getObject(JSONValue value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof JSONObject)) {
            throw new JSONException(NOT_AN_OBJECT);
        }
        return (JSONObject)value;
    }
}

