/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import net.pwall.json.JSON;
import net.pwall.json.JSONArray;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONValue;
import net.pwall.util.CharMapper;
import net.pwall.util.ListMap;
import net.pwall.util.Strings;

public class JSONFormat {
    public static final int DEFAULT_INDENTATION = 2;
    public static final String LINE_TERMINATOR = System.getProperty("line.separator");
    private int currentIndentation;
    private int indentationIncrement;
    private boolean newlineRequired;
    private static JSONFormat instance = new JSONFormat();

    public JSONFormat(int currentIndentation, int indentationIncrement, boolean newlineRequired) {
        this.currentIndentation = currentIndentation;
        this.indentationIncrement = indentationIncrement;
        this.newlineRequired = newlineRequired;
    }

    public JSONFormat() {
        this(0, 2, false);
    }

    public int getCurrentIndentation() {
        return this.currentIndentation;
    }

    public int getIndentationIncrement() {
        return this.indentationIncrement;
    }

    public static JSONFormat create() {
        return instance;
    }

    public boolean isNewlineRequired() {
        return this.newlineRequired;
    }

    public JSONFormat newLineAfter() {
        return new JSONFormat(this.currentIndentation, this.indentationIncrement, true);
    }

    public JSONFormat noNewLineAfter() {
        return new JSONFormat(this.currentIndentation, this.indentationIncrement, false);
    }

    public JSONFormat indent() {
        return new JSONFormat(this.currentIndentation + this.indentationIncrement, this.indentationIncrement, this.newlineRequired);
    }

    public String format(JSONValue value) {
        StringBuilder sb = new StringBuilder();
        try {
            this.appendTo(sb, value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public void appendTo(Appendable a, JSONValue value) throws IOException {
        this.appendTo(a, value, this.currentIndentation, this.currentIndentation);
        if (this.newlineRequired) {
            a.append(LINE_TERMINATOR);
        }
    }

    private void appendTo(Appendable a, JSONValue value, int indent, int initialIndex) throws IOException {
        for (int i = initialIndex; i > 0; --i) {
            a.append(' ');
        }
        if (value == null) {
            a.append("null");
        } else if (value instanceof JSONObject) {
            JSONObject object = (JSONObject)value;
            a.append('{');
            if (object.size() > 0) {
                indent += this.indentationIncrement;
                a.append(LINE_TERMINATOR);
                int i = 0;
                while (true) {
                    ListMap.Entry entry = object.getEntry(i++);
                    for (int j = indent; j > 0; --j) {
                        a.append(' ');
                    }
                    a.append('\"');
                    Strings.appendEscaped((Appendable)a, (CharSequence)((CharSequence)entry.getKey()), (CharMapper)JSON.charMapper);
                    a.append('\"').append(':');
                    this.appendTo(a, (JSONValue)entry.getValue(), indent, 1);
                    if (i >= object.size()) break;
                    a.append(',');
                    a.append(LINE_TERMINATOR);
                }
                a.append(LINE_TERMINATOR);
                for (int j = indent -= this.indentationIncrement; j > 0; --j) {
                    a.append(' ');
                }
            }
            a.append('}');
        } else if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            a.append('[');
            if (array.size() > 0) {
                indent += this.indentationIncrement;
                a.append(LINE_TERMINATOR);
                int i = 0;
                while (true) {
                    this.appendTo(a, (JSONValue)array.get(i++), indent, indent);
                    if (i >= array.size()) break;
                    a.append(',');
                    a.append(LINE_TERMINATOR);
                }
                a.append(LINE_TERMINATOR);
                for (int j = indent -= this.indentationIncrement; j > 0; --j) {
                    a.append(' ');
                }
            }
            a.append(']');
        } else {
            value.appendJSON(a);
        }
    }
}

