/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import net.pwall.json.JSONException;
import net.pwall.json.JSONNumberValue;
import net.pwall.util.Strings;

public class JSONInteger
extends Number
implements JSONNumberValue {
    private static final long serialVersionUID = -4271512047065758655L;
    public static final JSONInteger ZERO = new JSONInteger(0);
    private int value;

    public JSONInteger(int value) {
        this.value = value;
    }

    public int get() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void appendJSON(Appendable a) throws IOException {
        Strings.appendInt((Appendable)a, (int)this.value);
    }

    public String toString() {
        return this.toJSON();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof JSONNumberValue && ((JSONNumberValue)other).valueEquals(this.value);
    }

    @Override
    public boolean valueEquals(int other) {
        return other == this.value;
    }

    @Override
    public boolean valueEquals(long other) {
        return other == (long)this.value;
    }

    @Override
    public boolean valueEquals(float other) {
        return other == (float)this.value;
    }

    @Override
    public boolean valueEquals(double other) {
        return other == (double)this.value;
    }

    public static JSONInteger valueOf(int value) {
        return value == 0 ? ZERO : new JSONInteger(value);
    }

    public static JSONInteger valueOf(String string) {
        try {
            return JSONInteger.valueOf(Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            throw new JSONException("Illegal JSON number");
        }
    }
}

