/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import net.pwall.json.JSONException;
import net.pwall.json.JSONNumberValue;
import net.pwall.util.Strings;

public class JSONLong
extends Number
implements JSONNumberValue {
    private static final long serialVersionUID = 4342545343730856828L;
    public static final JSONLong ZERO = new JSONLong(0L);
    private long value;

    public JSONLong(long value) {
        this.value = value;
    }

    public long get() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void appendJSON(Appendable a) throws IOException {
        Strings.appendLong((Appendable)a, (long)this.value);
    }

    public String toString() {
        return this.toJSON();
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof JSONNumberValue && ((JSONNumberValue)other).valueEquals(this.value);
    }

    @Override
    public boolean valueEquals(int other) {
        return (long)other == this.value;
    }

    @Override
    public boolean valueEquals(long other) {
        return other == this.value;
    }

    @Override
    public boolean valueEquals(float other) {
        return other == (float)this.value;
    }

    @Override
    public boolean valueEquals(double other) {
        return other == (double)this.value;
    }

    public static JSONLong valueOf(long value) {
        return value == 0L ? ZERO : new JSONLong(value);
    }

    public static JSONLong valueOf(String string) {
        try {
            return JSONLong.valueOf(Long.parseLong(string));
        }
        catch (NumberFormatException e) {
            throw new JSONException("Illegal JSON number");
        }
    }
}

