/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.pwall.json.JSON;
import net.pwall.json.JSONArray;
import net.pwall.json.JSONComposite;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONValue;
import net.pwall.util.CharMapper;
import net.pwall.util.ListMap;
import net.pwall.util.Strings;

public class JSONMapping<V extends JSONValue>
extends ListMap<String, V>
implements JSONComposite,
Iterable<String> {
    private static final long serialVersionUID = 4424892153019501302L;

    public JSONMapping() {
    }

    public JSONMapping(int capacity) {
        super(capacity);
    }

    public JSONMapping(JSONMapping<V> other) {
        super(other);
    }

    public JSONMapping(Map<String, ? extends V> map) {
        super(map);
    }

    public String getString(String key) {
        return JSON.getString((JSONValue)this.get(key));
    }

    public int getInt(String key) {
        return JSON.getInt((JSONValue)this.get(key));
    }

    public long getLong(String key) {
        return JSON.getLong((JSONValue)this.get(key));
    }

    public float getFloat(String key) {
        return JSON.getFloat((JSONValue)this.get(key));
    }

    public double getDouble(String key) {
        return JSON.getDouble((JSONValue)this.get(key));
    }

    public boolean getBoolean(String key) {
        return JSON.getBoolean((JSONValue)this.get(key));
    }

    public JSONArray getArray(String key) {
        return JSON.getArray((JSONValue)this.get(key));
    }

    public JSONObject getObject(String key) {
        return JSON.getObject((JSONValue)this.get(key));
    }

    @Override
    public Iterator<String> iterator() {
        return this.keySet().iterator();
    }

    @Override
    public void appendJSON(Appendable a) throws IOException {
        a.append('{');
        int n = this.list.size();
        if (n > 0) {
            int i = 0;
            while (true) {
                ListMap.Entry entry = (ListMap.Entry)this.list.get(i++);
                a.append('\"');
                Strings.appendEscaped((Appendable)a, (CharSequence)((CharSequence)entry.getKey()), (CharMapper)JSON.charMapper);
                a.append('\"').append(':');
                JSON.appendJSON(a, (JSONValue)entry.getValue());
                if (i >= n) break;
                a.append(',');
            }
        }
        a.append('}');
    }

    @Override
    public boolean isSimple() {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!(((ListMap.Entry)this.list.get(i)).getValue() instanceof JSONComposite)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toJSON();
    }

    public int hashCode() {
        int result = 0;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            result ^= ((ListMap.Entry)this.list.get(i)).hashCode();
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JSONMapping)) {
            return false;
        }
        JSONMapping otherMapping = (JSONMapping)other;
        if (this.list.size() != otherMapping.list.size()) {
            return false;
        }
        for (ListMap.Entry entry : this.list) {
            if (Objects.equals(entry.getValue(), otherMapping.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

