/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.pwall.json.JSONException;
import net.pwall.json.JSONNumberValue;

public class JSONFloat
extends JSONNumberValue {
    private static final long serialVersionUID = 5622220776852501864L;
    public static final JSONFloat ZERO = new JSONFloat(0.0f);
    private final float value;

    public JSONFloat(float value) {
        if (Float.isNaN(value)) {
            throw new JSONException("Can't store NaN as JSON");
        }
        if (Float.isInfinite(value)) {
            throw new JSONException("Can't store infinity as JSON");
        }
        this.value = value;
    }

    public float get() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf((long)this.value);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public String toJSON() {
        return String.valueOf(this.value);
    }

    @Override
    public void appendJSON(Appendable a) throws IOException {
        a.append(this.toJSON());
    }

    public String toString() {
        return this.toJSON();
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof JSONNumberValue && ((JSONNumberValue)other).valueEquals(this.value);
    }

    @Override
    public boolean valueEquals(int other) {
        return (float)other == this.value;
    }

    @Override
    public boolean valueEquals(long other) {
        return (float)other == this.value;
    }

    @Override
    public boolean valueEquals(float other) {
        return other == this.value;
    }

    @Override
    public boolean valueEquals(double other) {
        return other == (double)this.value;
    }

    @Override
    public boolean valueEquals(BigInteger other) {
        return other.equals(BigInteger.valueOf((long)this.value));
    }

    @Override
    public boolean valueEquals(BigDecimal other) {
        return other.compareTo(BigDecimal.valueOf(this.value)) == 0;
    }

    public static JSONFloat valueOf(float value) {
        return value == 0.0f ? ZERO : new JSONFloat(value);
    }

    public static JSONFloat valueOf(String string) {
        try {
            return JSONFloat.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException e) {
            throw new JSONException("Illegal JSON number");
        }
    }
}

