/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.pwall.json.JSONException;
import net.pwall.json.JSONNumberValue;

public class JSONDecimal
extends JSONNumberValue {
    private static final long serialVersionUID = 5004532203973159380L;
    public static final JSONDecimal ZERO = new JSONDecimal(BigDecimal.ZERO);
    private final BigDecimal bigDecimal;
    private final String string;

    public JSONDecimal(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
        this.string = bigDecimal.toString();
    }

    public JSONDecimal(String string) {
        try {
            this.bigDecimal = new BigDecimal(string);
        }
        catch (Exception e) {
            throw new JSONException("Illegal JSON number");
        }
        this.string = string;
    }

    public BigDecimal get() {
        return this.bigDecimal;
    }

    @Override
    public int intValue() {
        return this.bigDecimal.intValue();
    }

    @Override
    public long longValue() {
        return this.bigDecimal.longValue();
    }

    @Override
    public float floatValue() {
        return this.bigDecimal.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimal.doubleValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.bigDecimal.toBigInteger();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.bigDecimal;
    }

    @Override
    public String toJSON() {
        return this.string;
    }

    @Override
    public void appendJSON(Appendable a) throws IOException {
        a.append(this.toJSON());
    }

    public String toString() {
        return this.toJSON();
    }

    public int hashCode() {
        return this.bigDecimal.hashCode();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof JSONNumberValue && ((JSONNumberValue)other).valueEquals(this.bigDecimal);
    }

    @Override
    public boolean valueEquals(int other) {
        return BigDecimal.valueOf(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(long other) {
        return BigDecimal.valueOf(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(float other) {
        return BigDecimal.valueOf(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(double other) {
        return BigDecimal.valueOf(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(BigInteger other) {
        return new BigDecimal(other).compareTo(this.bigDecimal) == 0;
    }

    @Override
    public boolean valueEquals(BigDecimal other) {
        return other.equals(this.bigDecimal);
    }

    public static JSONDecimal valueOf(BigDecimal bigDecimal) {
        return bigDecimal.equals(BigDecimal.ZERO) ? ZERO : new JSONDecimal(bigDecimal);
    }

    public static JSONDecimal valueOf(String s) {
        return s.equals("0") || s.equals("0.0") ? ZERO : new JSONDecimal(s);
    }

    public static JSONDecimal valueOf(double d) {
        return d == 0.0 ? ZERO : new JSONDecimal(BigDecimal.valueOf(d));
    }

    public static JSONDecimal valueOf(long i) {
        return i == 0L ? ZERO : new JSONDecimal(BigDecimal.valueOf(i));
    }
}

