/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.pwall.json.JSON;
import net.pwall.json.JSONArray;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONComposite;
import net.pwall.json.JSONException;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONValue;

public class JSONSequence<V extends JSONValue>
extends ArrayList<V>
implements JSONComposite {
    private static final long serialVersionUID = 34670706002893562L;

    public JSONSequence() {
    }

    public JSONSequence(int capacity) {
        super(capacity);
    }

    @SafeVarargs
    public JSONSequence(V ... values) {
        super(values.length);
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            this.add(values[i]);
        }
    }

    public JSONSequence(Collection<? extends V> collection) {
        super(collection);
    }

    @Override
    public List<Object> toSimpleValue() {
        int n = this.size();
        ArrayList<Object> list = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            list.add(JSONValue.simpleValue((JSONValue)this.get(i)));
        }
        return list;
    }

    public String getString(int index) {
        return JSON.getString((JSONValue)this.get(index));
    }

    public int getInt(int index) {
        return JSON.getInt((JSONValue)this.get(index));
    }

    public long getLong(int index) {
        return JSON.getLong((JSONValue)this.get(index));
    }

    public float getFloat(int index) {
        return JSON.getFloat((JSONValue)this.get(index));
    }

    public double getDouble(int index) {
        return JSON.getDouble((JSONValue)this.get(index));
    }

    public BigDecimal getDecimal(int index) {
        return JSON.getDecimal((JSONValue)this.get(index));
    }

    public boolean getBoolean(int index) {
        return JSON.getBoolean((JSONValue)this.get(index));
    }

    public JSONArray getArray(int index) {
        return JSON.getArray((JSONValue)this.get(index));
    }

    public JSONObject getObject(int index) {
        return JSON.getObject((JSONValue)this.get(index));
    }

    public Iterable<String> strings() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new StringIterator();
            }
        };
    }

    public Iterable<Integer> ints() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new IntegerIterator();
            }
        };
    }

    public Iterable<Long> longs() {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new LongIterator();
            }
        };
    }

    public Iterable<Double> doubles() {
        return new Iterable<Double>(){

            @Override
            public Iterator<Double> iterator() {
                return new DoubleIterator();
            }
        };
    }

    public Iterable<Float> floats() {
        return new Iterable<Float>(){

            @Override
            public Iterator<Float> iterator() {
                return new FloatIterator();
            }
        };
    }

    public Iterable<Boolean> booleans() {
        return new Iterable<Boolean>(){

            @Override
            public Iterator<Boolean> iterator() {
                return new BooleanIterator();
            }
        };
    }

    public Iterable<JSONArray> arrays() {
        return new Iterable<JSONArray>(){

            @Override
            public Iterator<JSONArray> iterator() {
                return new ArrayIterator();
            }
        };
    }

    public Iterable<JSONObject> objects() {
        return new Iterable<JSONObject>(){

            @Override
            public Iterator<JSONObject> iterator() {
                return new ObjectIterator();
            }
        };
    }

    @Override
    public void appendJSON(Appendable a) throws IOException {
        a.append('[');
        if (this.size() > 0) {
            int i = 0;
            while (true) {
                JSON.appendJSON(a, (JSONValue)this.get(i++));
                if (i >= this.size()) break;
                a.append(',');
            }
        }
        a.append(']');
    }

    @Override
    public boolean isSimple() {
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.get(i) instanceof JSONComposite)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.toJSON();
    }

    @Override
    public boolean equals(Object other) {
        return other == this || other instanceof JSONSequence && super.equals(other);
    }

    public class ObjectIterator
    extends BaseIterator<JSONObject> {
        @Override
        public JSONObject next() {
            return JSON.getObject((JSONValue)this.iterator.next());
        }
    }

    public class ArrayIterator
    extends BaseIterator<JSONArray> {
        @Override
        public JSONArray next() {
            return JSON.getArray((JSONValue)this.iterator.next());
        }
    }

    public class BooleanIterator
    extends BaseIterator<Boolean> {
        @Override
        public Boolean next() {
            JSONValue value = (JSONValue)this.iterator.next();
            if (value == null) {
                return null;
            }
            if (!(value instanceof JSONBoolean)) {
                throw new JSONException("Not a JSON boolean");
            }
            return ((JSONBoolean)value).booleanValue();
        }
    }

    public class FloatIterator
    extends BaseIterator<Float> {
        @Override
        public Float next() {
            JSONValue value = (JSONValue)this.iterator.next();
            if (value == null) {
                return null;
            }
            if (!(value instanceof Number)) {
                throw new JSONException("Not a JSON number");
            }
            return Float.valueOf(((Number)((Object)value)).floatValue());
        }
    }

    public class DoubleIterator
    extends BaseIterator<Double> {
        @Override
        public Double next() {
            JSONValue value = (JSONValue)this.iterator.next();
            if (value == null) {
                return null;
            }
            if (!(value instanceof Number)) {
                throw new JSONException("Not a JSON number");
            }
            return ((Number)((Object)value)).doubleValue();
        }
    }

    public class LongIterator
    extends BaseIterator<Long> {
        @Override
        public Long next() {
            JSONValue value = (JSONValue)this.iterator.next();
            if (value == null) {
                return null;
            }
            if (!(value instanceof Number)) {
                throw new JSONException("Not a JSON number");
            }
            return ((Number)((Object)value)).longValue();
        }
    }

    public class IntegerIterator
    extends BaseIterator<Integer> {
        @Override
        public Integer next() {
            JSONValue value = (JSONValue)this.iterator.next();
            if (value == null) {
                return null;
            }
            if (!(value instanceof Number)) {
                throw new JSONException("Not a JSON number");
            }
            return ((Number)((Object)value)).intValue();
        }
    }

    public class StringIterator
    extends BaseIterator<String> {
        @Override
        public String next() {
            return JSON.getString((JSONValue)this.iterator.next());
        }
    }

    public abstract class BaseIterator<T>
    implements Iterator<T> {
        protected Iterator<V> iterator;

        public BaseIterator() {
            this.iterator = JSONSequence.this.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

