/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json;

import java.io.IOException;
import java.util.Objects;
import net.pwall.json.JSONValue;
import net.pwall.util.Strings;

public class JSONString
implements JSONValue,
CharSequence {
    private static final long serialVersionUID = -7870545532058668339L;
    private final String value;

    public JSONString(CharSequence cs) {
        this.value = Objects.requireNonNull(cs).toString();
    }

    public String get() {
        return this.value;
    }

    @Override
    public String toSimpleValue() {
        return this.value;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public void appendJSON(Appendable a) throws IOException {
        a.append('\"');
        int i = 0;
        int n = this.value.length();
        while (i < n) {
            char ch;
            if ((ch = this.value.charAt(i++)) == '\"' || ch == '\\') {
                a.append('\\');
                a.append(ch);
                continue;
            }
            if (ch >= ' ' && ch < '\u007f') {
                a.append(ch);
                continue;
            }
            if (ch == '\b') {
                a.append('\\');
                a.append('b');
                continue;
            }
            if (ch == '\f') {
                a.append('\\');
                a.append('f');
                continue;
            }
            if (ch == '\n') {
                a.append('\\');
                a.append('n');
                continue;
            }
            if (ch == '\r') {
                a.append('\\');
                a.append('r');
                continue;
            }
            if (ch == '\t') {
                a.append('\\');
                a.append('t');
                continue;
            }
            a.append('\\');
            a.append('u');
            Strings.appendHex((Appendable)a, (char)ch);
        }
        a.append('\"');
    }

    @Override
    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof JSONString && this.value.equals(((JSONString)other).value);
    }
}

