/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class ChunkedArrayList<E>
extends AbstractList<E>
implements RandomAccess {
    public static final int defaultChunkSize = 1000;
    public static final int defaultInitialChunks = 20;
    public static final int minimumChunkSize = 2;
    private List<List<E>> outerList;
    private int chunkSize;

    public ChunkedArrayList(int chunkSize, int initialChunks) {
        if (chunkSize < 2) {
            throw new IllegalArgumentException("Chunk size " + chunkSize + " too low");
        }
        this.outerList = new ArrayList<List<E>>(initialChunks);
        this.chunkSize = chunkSize;
    }

    public ChunkedArrayList(int chunkSize) {
        this(chunkSize, 20);
    }

    public ChunkedArrayList() {
        this(1000);
    }

    public ChunkedArrayList(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public int size() {
        long result;
        int n = this.outerList.size();
        if (n == 0) {
            return 0;
        }
        return (result = (long)(--n) * (long)this.chunkSize + (long)this.outerList.get(n).size()) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)result;
    }

    @Override
    public boolean contains(Object o) {
        for (List<E> innerList : this.outerList) {
            if (!innerList.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        List<E> innerList;
        int n = this.outerList.size();
        if (n == 0 || (innerList = this.outerList.get(n - 1)).size() == this.chunkSize) {
            innerList = new ArrayList(this.chunkSize);
            this.outerList.add(innerList);
        }
        innerList.add(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.outerList.size();
        for (int i = 0; i < n; ++i) {
            List<E> innerList = this.outerList.get(i);
            if (!innerList.remove(o)) continue;
            if (innerList.size() == 0) {
                this.outerList.remove(i);
            } else {
                while (++i < n) {
                    List<E> innerListNext = this.outerList.get(i);
                    innerList.add(innerListNext.remove(0));
                    if (innerListNext.size() == 0) {
                        this.outerList.remove(i);
                        break;
                    }
                    innerList = innerListNext;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (List<E> innerList : this.outerList) {
            innerList.clear();
        }
        this.outerList.clear();
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
        return this.outerList.get(index / this.chunkSize).get(index % this.chunkSize);
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
        return this.outerList.get(index / this.chunkSize).set(index % this.chunkSize, element);
    }

    @Override
    public void add(int index, E element) {
        List<E> innerList;
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
        int i = index % this.chunkSize;
        for (int j = index / this.chunkSize; j < this.outerList.size(); ++j) {
            innerList = this.outerList.get(j);
            if (innerList.size() < this.chunkSize) {
                innerList.add(i, element);
                return;
            }
            E movedElement = innerList.remove(this.chunkSize - 1);
            innerList.add(i, element);
            element = movedElement;
            i = 0;
        }
        innerList = new ArrayList(this.chunkSize);
        this.outerList.add(innerList);
        innerList.add(element);
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
        }
        int i = index % this.chunkSize;
        int j = index / this.chunkSize;
        List<E> innerList = this.outerList.get(j);
        E result = innerList.remove(i);
        if (innerList.size() == 0) {
            this.outerList.remove(j);
        } else {
            while (++j < this.outerList.size()) {
                List<E> innerListNext = this.outerList.get(j);
                innerList.add(innerListNext.remove(0));
                if (innerListNext.size() == 0) {
                    this.outerList.remove(j);
                    break;
                }
                innerList = innerListNext;
            }
        }
        return result;
    }

    @Override
    public int indexOf(Object o) {
        int n = this.outerList.size();
        for (int i = 0; i < n; ++i) {
            List<E> innerList = this.outerList.get(i);
            int result = innerList.indexOf(o);
            if (result < 0) continue;
            return i * this.chunkSize + result;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.outerList.size() - 1; i >= 0; --i) {
            List<E> innerList = this.outerList.get(i);
            int result = innerList.lastIndexOf(o);
            if (result < 0) continue;
            return i * this.chunkSize + result;
        }
        return -1;
    }

    private String outOfBoundsMsg(int index) {
        return "Index: " + index + ", Size: " + this.size();
    }
}

