/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.pwall.util.ParseText;
import net.pwall.util.Strings;

public class ISO8601Date
extends Date {
    private static final long serialVersionUID = 7662874565511305042L;
    private static final int[] parseDays = new int[]{-1, 2, 3, 4, 5, 6, 7, 1, -1, -1};
    private static final char dateSeparator = '-';
    private static final char weekNumberSeparator = 'W';
    private static final char dateTimeSeparator = 'T';
    private static final char zeroTimeZoneIndicator = 'Z';
    private static final char timeSeparator = ':';
    private static final char commaDecimalSeparator = ',';
    private static final char dotDecimalSeparator = '.';
    private static final char defaultDecimalSeparator = new DecimalFormatSymbols().getDecimalSeparator();
    private static final char[] decimalSeparators = new char[]{',', '.'};
    private static final char plusSign = '+';
    private static final char minusSign = '-';
    private static final char[] plusOrMinus = new char[]{'+', '-'};
    public static final int YEAR_MASK = 2;
    public static final int MONTH_MASK = 4;
    public static final int WEEK_OF_YEAR_MASK = 8;
    public static final int DAY_OF_MONTH_MASK = 32;
    public static final int DAY_OF_YEAR_MASK = 64;
    public static final int DAY_OF_WEEK_MASK = 128;
    public static final int HOUR_OF_DAY_MASK = 2048;
    public static final int MINUTE_MASK = 4096;
    public static final int SECOND_MASK = 8192;
    public static final int MILLISECOND_MASK = 16384;
    public static final int ZONE_OFFSET_MASK = 32768;
    private TimeZone timeZone;

    public ISO8601Date() {
        this.timeZone = null;
    }

    public ISO8601Date(long date) {
        super(date);
        this.timeZone = null;
    }

    public ISO8601Date(String date) {
        this(ISO8601Date.decode(date));
    }

    public ISO8601Date(String date, TimeZone timeZone) {
        super(ISO8601Date.decode(date).getTimeInMillis());
        this.setTimeZone(timeZone);
    }

    public ISO8601Date(Date date, TimeZone timeZone) {
        super(date.getTime());
        this.setTimeZone(timeZone);
    }

    public ISO8601Date(Calendar cal) {
        super(cal.getTimeInMillis());
        this.setTimeZone(cal.getTimeZone());
    }

    public ISO8601Date(ISO8601Date date) {
        this(date, date.getTimeZone());
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public void setTime(long time) {
        super.setTime(time);
        this.timeZone = null;
    }

    @Override
    public String toString() {
        return ISO8601Date.toString(this, this.timeZone);
    }

    public static String toString(Date date, TimeZone timeZone) {
        StringBuilder sb = new StringBuilder(10);
        try {
            Calendar cal = Calendar.getInstance(timeZone != null ? timeZone : TimeZone.getDefault());
            cal.setTime(date);
            sb.append(cal.get(1));
            sb.append('-');
            Strings.append2Digits(sb, cal.get(2) + 1);
            sb.append('-');
            Strings.append2Digits(sb, cal.get(5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String toString(Date date) {
        return ISO8601Date.toString(date, null);
    }

    public static Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setFirstDayOfWeek(2);
        return cal;
    }

    public static Calendar decode(CharSequence str) {
        block24: {
            Calendar cal;
            block25: {
                ParseText text;
                block34: {
                    block39: {
                        block38: {
                            boolean complete;
                            block37: {
                                block36: {
                                    block26: {
                                        int mins;
                                        int hours;
                                        char sign;
                                        StringBuilder sb;
                                        block35: {
                                            block33: {
                                                block30: {
                                                    block31: {
                                                        block32: {
                                                            block28: {
                                                                block29: {
                                                                    block27: {
                                                                        if (str == null) {
                                                                            throw new IllegalArgumentException("ISO8601 string must not be null");
                                                                        }
                                                                        cal = ISO8601Date.getCalendar();
                                                                        cal.clear();
                                                                        complete = false;
                                                                        text = new ParseText(str);
                                                                        if (!text.matchDecFixed(4)) break block24;
                                                                        cal.set(1, text.getResultInt());
                                                                        if (text.isExhausted()) break block25;
                                                                        if (!text.match('-')) break block26;
                                                                        if (!text.match('W')) break block27;
                                                                        if (!text.matchDecFixed(2)) break block24;
                                                                        cal.set(3, text.getResultInt());
                                                                        if (!text.match('-')) break block28;
                                                                        if (!text.matchDecFixed(1)) break block24;
                                                                        cal.set(7, parseDays[text.getResultInt()]);
                                                                        complete = true;
                                                                        break block28;
                                                                    }
                                                                    if (!text.matchDecFixed(3)) break block29;
                                                                    cal.set(6, text.getResultInt());
                                                                    complete = true;
                                                                    break block28;
                                                                }
                                                                if (!text.matchDecFixed(2)) break block24;
                                                                cal.set(2, text.getResultInt() - 1);
                                                                if (!text.match('-')) break block28;
                                                                if (!text.matchDecFixed(2)) break block24;
                                                                cal.set(5, text.getResultInt());
                                                                complete = true;
                                                            }
                                                            if (!complete || !text.match('T')) break block30;
                                                            if (!text.matchDecFixed(2)) break block24;
                                                            cal.set(11, text.getResultInt());
                                                            if (!text.match(':')) break block31;
                                                            if (!text.matchDecFixed(2)) break block24;
                                                            cal.set(12, text.getResultInt());
                                                            if (!text.match(':')) break block32;
                                                            if (!text.matchDecFixed(2)) break block24;
                                                            cal.set(13, text.getResultInt());
                                                            if (text.matchAnyOf(decimalSeparators)) {
                                                                ISO8601Date.fractionSeconds(cal, text);
                                                            }
                                                            break block30;
                                                        }
                                                        if (text.matchAnyOf(decimalSeparators)) {
                                                            ISO8601Date.fractionMinutes(cal, text);
                                                        }
                                                        break block30;
                                                    }
                                                    if (text.matchAnyOf(decimalSeparators)) {
                                                        ISO8601Date.fractionHours(cal, text);
                                                    }
                                                }
                                                if (!text.match('Z')) break block33;
                                                cal.setTimeZone(TimeZone.getTimeZone("GMT"));
                                                cal.set(15, 0);
                                                break block34;
                                            }
                                            if (!text.matchAnyOf(plusOrMinus)) break block34;
                                            sb = new StringBuilder("GMT");
                                            sign = text.getResultChar();
                                            sb.append(sign);
                                            if (!text.matchDecFixed(2)) break block24;
                                            hours = text.getResultInt();
                                            sb.append(hours);
                                            sb.append(':');
                                            mins = 0;
                                            if (!text.match(':')) break block35;
                                            if (!text.matchDecFixed(2)) break block24;
                                            mins = text.getResultInt();
                                        }
                                        sb.append(mins);
                                        cal.setTimeZone(TimeZone.getTimeZone(sb.toString()));
                                        mins += hours * 60;
                                        if (sign == '-') {
                                            mins = -mins;
                                        }
                                        cal.set(15, mins * 60 * 1000);
                                        break block34;
                                    }
                                    if (!text.match('W')) break block36;
                                    if (!text.matchDecFixed(2)) break block24;
                                    cal.set(3, text.getResultInt());
                                    if (text.matchDecFixed(1)) {
                                        cal.set(7, parseDays[text.getResultInt()]);
                                        complete = true;
                                    }
                                    break block37;
                                }
                                if (text.matchDecFixed(4)) {
                                    int i = text.getResultInt();
                                    cal.set(2, i / 100 - 1);
                                    cal.set(5, i % 100);
                                    complete = true;
                                } else if (text.matchDecFixed(3)) {
                                    cal.set(6, text.getResultInt());
                                    complete = true;
                                } else if (text.matchDecFixed(2)) {
                                    cal.set(2, text.getResultInt() - 1);
                                }
                            }
                            if (!complete || !text.match('T')) break block38;
                            if (!text.matchDecFixed(2)) break block24;
                            cal.set(11, text.getResultInt());
                            if (text.matchDecFixed(2)) {
                                cal.set(12, text.getResultInt());
                                if (text.matchDecFixed(2)) {
                                    cal.set(13, text.getResultInt());
                                    if (text.matchAnyOf(decimalSeparators)) {
                                        ISO8601Date.fractionSeconds(cal, text);
                                    }
                                } else if (text.matchAnyOf(decimalSeparators)) {
                                    ISO8601Date.fractionMinutes(cal, text);
                                }
                            } else if (text.matchAnyOf(decimalSeparators)) {
                                ISO8601Date.fractionHours(cal, text);
                            }
                        }
                        if (!text.match('Z')) break block39;
                        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
                        cal.set(15, 0);
                        break block34;
                    }
                    if (!text.matchAnyOf(plusOrMinus)) break block34;
                    StringBuilder sb = new StringBuilder("GMT");
                    char sign = text.getResultChar();
                    sb.append(sign);
                    if (!text.matchDecFixed(2)) break block24;
                    int hours = text.getResultInt();
                    sb.append(hours);
                    sb.append(':');
                    int mins = 0;
                    if (text.matchDecFixed(2)) {
                        mins = text.getResultInt();
                    }
                    sb.append(mins);
                    cal.setTimeZone(TimeZone.getTimeZone(sb.toString()));
                    mins += hours * 60;
                    if (sign == '-') {
                        mins = -mins;
                    }
                    cal.set(15, mins * 60 * 1000);
                }
                if (!text.isExhausted()) break block24;
            }
            return cal;
        }
        throw new IllegalArgumentException("Illegal ISO8601 date string");
    }

    private static void fractionHours(Calendar cal, ParseText text) {
        ISO8601Date.checkFraction(text);
        long millis = ISO8601Date.adjustFraction(text.getResultLong() * 3600L, text.getResultLength());
        cal.set(12, (int)(millis / 60000L));
        if ((millis %= 60000L) != 0L) {
            cal.set(13, (int)(millis / 1000L));
            if ((millis %= 1000L) != 0L) {
                cal.set(14, (int)millis);
            }
        }
    }

    private static void fractionMinutes(Calendar cal, ParseText text) {
        ISO8601Date.checkFraction(text);
        long millis = ISO8601Date.adjustFraction(text.getResultLong() * 60L, text.getResultLength());
        cal.set(13, (int)(millis / 1000L));
        if ((millis %= 1000L) != 0L) {
            cal.set(14, (int)millis);
        }
    }

    private static void fractionSeconds(Calendar cal, ParseText text) {
        ISO8601Date.checkFraction(text);
        cal.set(14, (int)ISO8601Date.adjustFraction(text.getResultLong(), text.getResultLength()));
    }

    private static void checkFraction(ParseText text) {
        if (!text.matchDec(9)) {
            throw new IllegalArgumentException("Illegal fraction in ISO8601 date string");
        }
    }

    private static long adjustFraction(long value, int len) {
        if (len > 3) {
            while (len > 4) {
                value /= 10L;
                --len;
            }
            value = (value + 5L) / 10L;
        } else {
            while (len < 3) {
                value *= 10L;
                ++len;
            }
        }
        return value;
    }

    public static String toString(Calendar cal) {
        return ISO8601Date.toString(cal, true);
    }

    public static String toString(Calendar cal, boolean extended) {
        int fields = 0;
        if (cal.isSet(1)) {
            fields |= 2;
        }
        if (cal.isSet(2)) {
            fields |= 4;
        }
        if (cal.isSet(5)) {
            fields |= 0x20;
        }
        if (cal.isSet(3)) {
            fields |= 8;
        }
        if (cal.isSet(7)) {
            fields |= 0x80;
        }
        if (cal.isSet(6)) {
            fields |= 0x40;
        }
        if (cal.isSet(11)) {
            fields |= 0x800;
        }
        if (cal.isSet(12)) {
            fields |= 0x1000;
        }
        if (cal.isSet(13)) {
            fields |= 0x2000;
        }
        if (cal.isSet(14)) {
            fields |= 0x4000;
        }
        if (cal.isSet(15)) {
            fields |= 0x8000;
        }
        return ISO8601Date.toString(cal, extended, fields);
    }

    public static String toString(Calendar cal, boolean extended, int fields) {
        int anyTimeMask = 30720;
        StringBuilder sb = new StringBuilder();
        try {
            if (ISO8601Date.fieldSet(fields, 2)) {
                sb.append(cal.get(1));
                if (ISO8601Date.fieldSet(fields, 4)) {
                    if (extended) {
                        sb.append('-');
                    }
                    Strings.append2Digits(sb, cal.get(2) + 1);
                    if (ISO8601Date.fieldSet(fields, 32)) {
                        if (extended) {
                            sb.append('-');
                        }
                        Strings.append2Digits(sb, cal.get(5));
                        if (ISO8601Date.fieldSet(fields, anyTimeMask)) {
                            sb.append('T');
                            ISO8601Date.appendTime(sb, cal, extended, fields);
                        }
                    }
                } else if (ISO8601Date.fieldSet(fields, 8)) {
                    if (extended) {
                        sb.append('-');
                    }
                    sb.append('W');
                    Strings.append2Digits(sb, cal.get(3));
                    if (ISO8601Date.fieldSet(fields, 128)) {
                        int d = cal.get(7);
                        for (int i = 1; i < 8; ++i) {
                            if (parseDays[i] != d) continue;
                            if (extended) {
                                sb.append('-');
                            }
                            sb.append(i);
                            break;
                        }
                        if (ISO8601Date.fieldSet(fields, anyTimeMask)) {
                            sb.append('T');
                            ISO8601Date.appendTime(sb, cal, extended, fields);
                        }
                    }
                } else if (ISO8601Date.fieldSet(fields, 64)) {
                    if (extended) {
                        sb.append('-');
                    }
                    Strings.append3Digits(sb, cal.get(6));
                    if (ISO8601Date.fieldSet(fields, anyTimeMask)) {
                        sb.append('T');
                        ISO8601Date.appendTime(sb, cal, extended, fields);
                    }
                }
            } else {
                ISO8601Date.appendTime(sb, cal, extended, fields);
            }
            if (ISO8601Date.fieldSet(fields, 32768)) {
                int mins = cal.get(15);
                if (cal.getTimeZone().inDaylightTime(cal.getTime())) {
                    mins += cal.get(16);
                }
                if ((mins /= 60000) == 0) {
                    sb.append('Z');
                } else {
                    sb.append(mins < 0 ? (char)'-' : '+');
                    mins = Math.abs(mins);
                    Strings.append2Digits(sb, mins / 60);
                    mins %= 60;
                    if (extended) {
                        sb.append(':');
                    }
                    Strings.append2Digits(sb, mins);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    private static boolean fieldSet(int fields, int mask) {
        return (fields & mask) != 0;
    }

    private static void appendTime(StringBuilder sb, Calendar cal, boolean extended, int fields) throws IOException {
        Strings.append2Digits(sb, cal.get(11));
        if ((fields & 0x7000) != 0) {
            if (extended) {
                sb.append(':');
            }
            Strings.append2Digits(sb, cal.get(12));
            if ((fields & 0x6000) != 0) {
                if (extended) {
                    sb.append(':');
                }
                Strings.append2Digits(sb, cal.get(13));
                if ((fields & 0x4000) != 0) {
                    sb.append(defaultDecimalSeparator);
                    Strings.append3Digits(sb, cal.get(14));
                }
            }
        }
    }
}

