/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.io.IOException;
import net.pwall.util.CharMapper;
import net.pwall.util.Strings;

public class Java {
    public static final CharMapper stringMapper = codePoint -> {
        if (codePoint == 34) {
            return "\\\"";
        }
        if (codePoint == 92) {
            return "\\\\";
        }
        if (codePoint >= 32 && codePoint < 127) {
            return null;
        }
        if (codePoint == 10) {
            return "\\n";
        }
        if (codePoint == 13) {
            return "\\r";
        }
        if (codePoint == 9) {
            return "\\t";
        }
        if (codePoint == 8) {
            return "\\b";
        }
        if (codePoint == 12) {
            return "\\f";
        }
        return CharMapper.hexMapping(codePoint, 4, "\\u");
    };
    public static final CharMapper charMapper = codePoint -> {
        if (codePoint == 39) {
            return "\\'";
        }
        if (codePoint == 92) {
            return "\\\\";
        }
        if (codePoint >= 32 && codePoint < 127) {
            return null;
        }
        if (codePoint == 10) {
            return "\\n";
        }
        if (codePoint == 13) {
            return "\\r";
        }
        if (codePoint == 9) {
            return "\\t";
        }
        if (codePoint == 8) {
            return "\\b";
        }
        if (codePoint == 12) {
            return "\\f";
        }
        return CharMapper.hexMapping(codePoint, 4, "\\u");
    };

    private Java() {
    }

    public static String quote(String str) {
        if (str == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(str.length() + 8);
        sb.append('\"');
        try {
            Strings.appendEscaped(sb, str, stringMapper);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String quoteCharacter(char ch) {
        StringBuilder sb = new StringBuilder(8);
        sb.append('\'');
        String mapped = charMapper.map(ch);
        if (mapped != null) {
            sb.append(mapped);
        } else {
            sb.append(ch);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static CharSequence trim(CharSequence cs) {
        return Strings.trim(cs, Character::isWhitespace);
    }

    public static String trim(String str) {
        return Strings.trim(str, Character::isWhitespace);
    }

    public static boolean isAllSpace(CharSequence cs) {
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

