/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import net.pwall.util.CharMapper;

public class MultiCharMapper
implements CharMapper {
    private CharMapper[] mappers;

    public MultiCharMapper() {
        this.mappers = null;
    }

    public MultiCharMapper(CharMapper ... mappers) {
        this.mappers = mappers;
    }

    public void addCharMapper(CharMapper mapper) {
        if (this.mappers == null) {
            this.mappers = new CharMapper[]{mapper};
        } else {
            int n = this.mappers.length;
            CharMapper[] newArray = new CharMapper[n + 1];
            System.arraycopy(this.mappers, 0, newArray, 0, n);
            newArray[n] = mapper;
            this.mappers = newArray;
        }
    }

    @Override
    public String map(int codePoint) {
        if (this.mappers != null) {
            for (CharMapper mapper : this.mappers) {
                String result = mapper.map(codePoint);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

