/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.util.Map;
import java.util.Objects;
import net.pwall.util.ListMap;

public class SortedListMap<K extends Comparable<K>, V>
extends ListMap<K, V> {
    private static final long serialVersionUID = 8531216371555239765L;

    public SortedListMap() {
    }

    public SortedListMap(int capacity) {
        super(capacity);
    }

    public SortedListMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        int lo = 0;
        int hi = this.list.size();
        while (lo < hi) {
            int mid = lo + hi >> 1;
            ListMap.Entry entry = (ListMap.Entry)this.list.get(mid);
            int comp = ((Comparable)entry.getKey()).compareTo(key);
            if (comp == 0) {
                Object result = entry.getValue();
                entry.setValue(value);
                return (V)result;
            }
            if (comp < 0) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        this.list.add(lo, new ListMap.Entry<K, V>(key, value));
        return null;
    }

    @Override
    protected int findIndex(Object key) {
        Comparable keyObject = (Comparable)key;
        int lo = 0;
        int hi = this.list.size();
        while (lo < hi) {
            int mid = lo + hi >> 1;
            int comp = ((Comparable)((ListMap.Entry)this.list.get(mid)).getKey()).compareTo(keyObject);
            if (comp == 0) {
                return mid;
            }
            if (comp < 0) {
                lo = mid + 1;
                continue;
            }
            hi = mid;
        }
        return -1;
    }
}

