/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import java.util.ArrayList;
import java.util.List;

public class SyncQueue<T> {
    public static final int defaultInitialCapacity = 10;
    public static final int defaultMaxLength = 0;
    private List<T> queue;
    private int maxLength;

    public SyncQueue(int initialCapacity, int maxLength) {
        this.queue = new ArrayList<T>(initialCapacity);
        this.maxLength = maxLength;
    }

    public SyncQueue(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public SyncQueue() {
        this(10);
    }

    public synchronized boolean add(T object) {
        if (!this.checkCapacity()) {
            return false;
        }
        this.queue.add(object);
        this.notifyAll();
        return true;
    }

    public synchronized boolean addUnique(T object) {
        if (this.queue.contains(object)) {
            return true;
        }
        if (!this.checkCapacity()) {
            return false;
        }
        this.queue.add(object);
        this.notifyAll();
        return true;
    }

    public synchronized boolean insert(T object) {
        if (!this.checkCapacity()) {
            return false;
        }
        this.queue.add(0, object);
        this.notifyAll();
        return true;
    }

    public synchronized boolean insertUnique(T object) {
        this.queue.remove(object);
        if (!this.checkCapacity()) {
            return false;
        }
        this.queue.add(0, object);
        this.notifyAll();
        return true;
    }

    private boolean checkCapacity() {
        if (this.maxLength > 0) {
            while (this.queue.size() >= this.maxLength) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public synchronized boolean remove(T object) {
        if (!this.queue.remove(object)) {
            return false;
        }
        this.notifyAll();
        return true;
    }

    public synchronized T get() {
        while (this.queue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        T result = this.queue.remove(0);
        this.notifyAll();
        return result;
    }

    public synchronized int getSize() {
        return this.queue.size();
    }

    public synchronized int getMaxLength() {
        return this.maxLength;
    }

    public synchronized void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

