/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.util;

import net.pwall.util.ByteArrayBuilder;
import net.pwall.util.CharMapper;
import net.pwall.util.CharUnmapper;
import net.pwall.util.Strings;

public class URI {
    public static final String errorMessage = "URI %xx sequence invalid";
    public static final CharMapper charMapper = cp -> {
        if (cp > 127) {
            StringBuilder sb = new StringBuilder();
            ByteArrayBuilder bab = new ByteArrayBuilder();
            Strings.appendUTF8(bab, cp);
            for (int i = 0; i < bab.length(); ++i) {
                sb.append(CharMapper.hexMapping(bab.get(i), 2, "%"));
            }
            return sb.toString();
        }
        if (cp == 32) {
            return "+";
        }
        if (!URI.isUnreserved(cp)) {
            return CharMapper.hexMapping(cp, 2, "%", null);
        }
        return null;
    };
    public static final CharUnmapper charUnmapper = new CharUnmapper(){

        @Override
        public boolean isEscape(CharSequence s, int offset) {
            char ch = s.charAt(offset);
            return ch == '%' || ch == '+';
        }

        @Override
        public int unmap(StringBuilder sb, CharSequence s, int offset) {
            if (s.charAt(offset) == '+') {
                sb.append(' ');
                return 1;
            }
            if (offset + 3 <= s.length()) {
                sb.append((char)Strings.convertHexToInt(s, offset + 1, offset + 3));
                return 3;
            }
            throw new IllegalArgumentException(URI.errorMessage);
        }
    };

    private URI() throws IllegalAccessException {
        throw new IllegalAccessException("Attempt to instantiate URI class");
    }

    public static boolean isUnreserved(int cp) {
        return cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122 || cp >= 48 && cp <= 57 || cp == 45 || cp == 46 || cp == 95 || cp == 126;
    }

    public static String escape(String s) {
        return Strings.escape(s, charMapper);
    }

    public static String unescape(String s) {
        return Strings.unescape(s, charUnmapper);
    }
}

