/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import com.google.common.base.Optional;
import java.io.File;
import net.serenitybdd.core.webdriver.servicepools.DriverPathConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.GeckoDriverServiceExecutable;
import net.serenitybdd.core.webdriver.servicepools.ThreadsafeGeckoDriverService;
import net.thucydides.core.ThucydidesSystemProperty;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeckoServicePool
extends DriverServicePool<GeckoDriverService> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Override
    protected String serviceName() {
        return "gecko";
    }

    @Override
    protected WebDriver newDriverInstance(Capabilities capabilities) {
        return new FirefoxDriver(capabilities);
    }

    public GeckoServicePool() {
        this.configureGeckoDriverBinaries();
    }

    @Override
    protected GeckoDriverService newDriverService() {
        return ThreadsafeGeckoDriverService.createThreadsafeService(this.environmentVariables);
    }

    private void configureGeckoDriverBinaries() {
        Optional<File> geckoBinary = GeckoDriverServiceExecutable.inEnvironment(this.environmentVariables);
        if (geckoBinary.isPresent()) {
            DriverPathConfiguration.updateSystemProperty(ThucydidesSystemProperty.WEBDRIVER_GECKO_DRIVER.getPropertyName()).withExecutablePath((File)geckoBinary.get());
        }
    }
}

