/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractList;
import java.util.List;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.pages.WidgetObject;
import net.thucydides.core.annotations.locators.AbstractListItemHandler;
import net.thucydides.core.annotations.locators.WebElementFacadeListItemHandler;
import net.thucydides.core.annotations.locators.WidgetListItemHandler;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class SmartListHandler
implements InvocationHandler {
    private final ClassLoader loader;
    private final Class<?> interfaceType;
    private final ElementLocator locator;
    private final PageObject page;
    private final long implicitTimeoutInMilliseconds;
    private final long waitForTimeoutInMilliseconds;

    public SmartListHandler(ClassLoader loader, Class<?> interfaceType, ElementLocator locator, PageObject page, long implicitTimeoutInMilliseconds, long waitForTimeoutInMilliseconds) {
        this.loader = loader;
        this.interfaceType = interfaceType;
        this.locator = locator;
        this.page = page;
        this.implicitTimeoutInMilliseconds = implicitTimeoutInMilliseconds;
        this.waitForTimeoutInMilliseconds = waitForTimeoutInMilliseconds;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
        List elements = this.locator.findElements();
        FacadeList facadeList = new FacadeList(elements);
        try {
            return method.invoke(facadeList, objects);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private class FacadeList<T>
    extends AbstractList<T> {
        private final List<WebElement> elms;

        private FacadeList(List<WebElement> elms) {
            this.elms = elms;
        }

        @Override
        public T get(int index) {
            WebElement elm = this.elms.get(index);
            return this.newProxyElementOfList(elm);
        }

        @Override
        public int size() {
            return this.elms.size();
        }

        private T newProxyElementOfList(WebElement element) {
            AbstractListItemHandler handler = null;
            if (WidgetObject.class.isAssignableFrom(SmartListHandler.this.interfaceType)) {
                handler = new WidgetListItemHandler(SmartListHandler.this.interfaceType, SmartListHandler.this.locator, element, SmartListHandler.this.page, SmartListHandler.this.implicitTimeoutInMilliseconds, SmartListHandler.this.waitForTimeoutInMilliseconds);
            } else if (WebElementFacade.class.isAssignableFrom(SmartListHandler.this.interfaceType)) {
                handler = new WebElementFacadeListItemHandler(SmartListHandler.this.interfaceType, SmartListHandler.this.locator, element, SmartListHandler.this.page, SmartListHandler.this.implicitTimeoutInMilliseconds, SmartListHandler.this.waitForTimeoutInMilliseconds);
            }
            if (handler != null) {
                return (T)Proxy.newProxyInstance(SmartListHandler.this.loader, new Class[]{SmartListHandler.this.interfaceType}, (InvocationHandler)handler);
            }
            if (WebElement.class.isAssignableFrom(SmartListHandler.this.interfaceType)) {
                return (T)element;
            }
            throw new RuntimeException("Unrecognized element type: " + SmartListHandler.this.interfaceType.getCanonicalName());
        }
    }
}

