/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.thucydides.core.model.DataSet;
import net.thucydides.core.model.DataSetDescriptor;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestResult;
import org.apache.commons.lang3.StringUtils;

public class DataTable {
    private final List<String> headers;
    private final List<DataTableRow> rows;
    private final boolean predefinedRows;
    private String scenarioOutline;
    private List<DataSetDescriptor> dataSetDescriptors;
    private transient AtomicInteger currentRow = new AtomicInteger(0);
    private static final List<DataTableRow> NO_ROWS = new ArrayList<DataTableRow>();
    private static String[] REGEX_CHARS = new String[]{"{", "}", "(", ")", "[", "]", "\\", ".", "?", "*", "+", "^", "$", "|"};
    private static String[] ESCAPED_REGEX_CHARS = new String[]{"\\{", "\\}", "\\(", "\\)", "\\[", "\\]", "\\\\", "\\.", "\\?", "\\*", "\\+", "\\^", "\\$", "\\|"};

    protected DataTable(List<String> headers, List<DataTableRow> rows) {
        this(null, headers, new CopyOnWriteArrayList<DataTableRow>(rows), null, null, (List<DataSetDescriptor>)ImmutableList.of((Object)DataSetDescriptor.DEFAULT_DESCRIPTOR));
    }

    protected DataTable(List<String> headers, List<DataTableRow> rows, String title, String description) {
        this(null, headers, new CopyOnWriteArrayList<DataTableRow>(rows), title, description, (List<DataSetDescriptor>)ImmutableList.of((Object)new DataSetDescriptor(0, 0, title, description)));
    }

    protected DataTable(String scenarioOutline, List<String> headers, List<DataTableRow> rows, String title, String description, List<DataSetDescriptor> dataSetDescriptors) {
        this.scenarioOutline = scenarioOutline;
        this.headers = headers;
        this.rows = new CopyOnWriteArrayList<DataTableRow>(rows);
        this.predefinedRows = !rows.isEmpty();
        this.dataSetDescriptors = dataSetDescriptors;
        if (title != null || description != null) {
            this.setLatestNameAndDescription(title, description);
        }
    }

    protected DataTable(List<String> headers, List<DataTableRow> rows, boolean predefinedRows, String scenarioOutline, List<DataSetDescriptor> dataSetDescriptors, AtomicInteger currentRow) {
        this.headers = headers;
        this.rows = rows;
        this.predefinedRows = predefinedRows;
        this.scenarioOutline = scenarioOutline;
        this.dataSetDescriptors = dataSetDescriptors;
        this.currentRow = currentRow;
    }

    public void setScenarioOutline(String scenarioOutline) {
        this.scenarioOutline = scenarioOutline;
    }

    public static DataTableBuilder withHeaders(List<String> headers) {
        return new DataTableBuilder(headers);
    }

    Optional<String> scenarioOutline() {
        return Optional.ofNullable(this.scenarioOutline);
    }

    public List<String> getHeaders() {
        return ImmutableList.copyOf(this.headers);
    }

    public List<DataTableRow> getRows() {
        return ImmutableList.copyOf(this.rows);
    }

    public RowValueAccessor row(int rowNumber) {
        return new RowValueAccessor(this, rowNumber);
    }

    public RowValueAccessor nextRow() {
        return new RowValueAccessor(this, this.nextRowNumber());
    }

    boolean atLastRow() {
        return this.rows.isEmpty() || this.currentRow.get() == this.rows.size() - 1;
    }

    public RowValueAccessor currentRow() {
        return new RowValueAccessor(this, this.currentRowNumber());
    }

    private int nextRowNumber() {
        return this.currentRow.incrementAndGet();
    }

    private int currentRowNumber() {
        return this.currentRow.intValue();
    }

    public void addRow(Map<String, ?> data) {
        this.addRow(new DataTableRow((List<? extends Object>)ImmutableList.copyOf(data.values())));
    }

    public List<DataSetDescriptor> getDataSetDescriptors() {
        return this.dataSetDescriptors;
    }

    void addRow(DataTableRow dataTableRow) {
        this.appendRow(dataTableRow);
        this.currentRow.set(this.rows.size() - 1);
    }

    public void appendRow(Map<String, ?> data) {
        this.appendRow(new DataTableRow((List<? extends Object>)ImmutableList.copyOf(data.values())));
    }

    void appendRow(DataTableRow dataTableRow) {
        this.rows.add(dataTableRow);
    }

    public void addRows(List<DataTableRow> rows) {
        for (DataTableRow row : rows) {
            DataTableRow newRow = new DataTableRow((List<? extends Object>)ImmutableList.copyOf(row.getValues()));
            newRow.setResult(row.getResult());
            this.rows.add(newRow);
        }
        this.currentRow.set(rows.size() - 1);
    }

    private void setLatestNameAndDescription(String name, String description) {
        this.dataSetDescriptors = this.dataSetDescriptors == null || this.dataSetDescriptors.isEmpty() ? ImmutableList.of((Object)new DataSetDescriptor(0, 0, name, description)) : this.replaceLatestDescriptor(this.last(this.dataSetDescriptors).withNameAndDescription(name, description));
    }

    private List<DataSetDescriptor> replaceLatestDescriptor(DataSetDescriptor updatedLatestDescriptor) {
        List<DataSetDescriptor> previousDescriptors = this.dataSetDescriptors.subList(0, this.dataSetDescriptors.size() - 1);
        return new ImmutableList.Builder().addAll(previousDescriptors).add((Object)updatedLatestDescriptor).build();
    }

    public void startNewDataSet(String name, String description) {
        this.updateLatestRowCount();
        this.dataSetDescriptors = new ImmutableList.Builder().addAll(this.dataSetDescriptors).add((Object)new DataSetDescriptor(this.rows.size(), 0, name, description)).build();
    }

    private void updateLatestRowCount() {
        DataSetDescriptor currentDescriptor = this.last(this.dataSetDescriptors);
        int currentRowCount = this.rows.size() - currentDescriptor.getStartRow();
        this.dataSetDescriptors = this.replaceLatestDescriptor(currentDescriptor.withRowCount(currentRowCount));
    }

    private DataSetDescriptor last(List<DataSetDescriptor> dataSetDescriptors) {
        return dataSetDescriptors.get(dataSetDescriptors.size() - 1);
    }

    boolean hasPredefinedRows() {
        return this.predefinedRows;
    }

    public int getSize() {
        return this.rows.size();
    }

    public List<DataSet> getDataSets() {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (DataSetDescriptor descriptor : this.dataSetDescriptors) {
            dataSets.add(new DataSet(descriptor.getStartRow(), descriptor.getRowCount(), descriptor.getName(), descriptor.getDescription(), this.rows));
        }
        return dataSets;
    }

    void updateRowResultsTo(TestResult result) {
        for (DataTableRow row : this.rows) {
            row.setResult(result);
        }
    }

    public String restoreVariablesIn(String stepDescription) {
        for (int column = 0; column < this.getHeaders().size(); ++column) {
            String correspondingValueInFirstRow = this.getRows().get(0).getStringValues().get(column);
            if (!StringUtils.isNotEmpty((CharSequence)correspondingValueInFirstRow)) continue;
            stepDescription = stepDescription.replaceAll("\\b" + this.withEscapedRegExChars(correspondingValueInFirstRow) + "\\b", "{{" + column + "}}");
        }
        int field = 0;
        for (String header : this.getHeaders()) {
            stepDescription = StringUtils.replace((String)stepDescription, (String)("{{" + field + "}}"), (String)("<" + header + ">"));
            ++field;
        }
        return stepDescription;
    }

    private String withEscapedRegExChars(String value) {
        return StringUtils.replaceEach((String)value, (String[])REGEX_CHARS, (String[])ESCAPED_REGEX_CHARS);
    }

    public static class RowValueAccessor {
        private final DataTable dataTable;
        private final int rowNumber;

        RowValueAccessor(DataTable dataTable, int rowNumber) {
            this.dataTable = dataTable;
            this.rowNumber = rowNumber;
        }

        public void hasResult(TestResult result) {
            ((DataTableRow)this.dataTable.rows.get(this.rowNumber)).updateResult(result);
        }

        public Map<String, String> toStringMap() {
            HashMap<String, String> rowData = new HashMap<String, String>();
            int i = 0;
            for (Object object : ((DataTableRow)this.dataTable.rows.get(this.rowNumber)).getValues()) {
                rowData.put((String)this.dataTable.headers.get(i), object.toString());
                ++i;
            }
            return rowData;
        }
    }

    public static class DataTableBuilder {
        final String scenarioOutline;
        final List<String> headers;
        final List<DataTableRow> rows;
        final String description;
        final String title;
        final List<DataSetDescriptor> descriptors;

        DataTableBuilder(List<String> headers) {
            this(null, headers, NO_ROWS, null, null, (List<DataSetDescriptor>)ImmutableList.of((Object)DataSetDescriptor.DEFAULT_DESCRIPTOR));
        }

        DataTableBuilder(String scenarioOutline, List<String> headers, List<DataTableRow> rows, String title, String description, List<DataSetDescriptor> descriptors) {
            this.scenarioOutline = scenarioOutline;
            this.headers = headers;
            this.rows = rows;
            this.description = description;
            this.title = title;
            this.descriptors = descriptors;
        }

        public DataTableBuilder andScenarioOutline(String scenarioOutline) {
            return new DataTableBuilder(scenarioOutline, this.headers, this.rows, this.title, this.description, this.descriptors);
        }

        public DataTableBuilder andCopyRowDataFrom(DataTableRow row) {
            ArrayList<DataTableRow> rows = new ArrayList<DataTableRow>();
            rows.add(new DataTableRow(row.getValues()));
            return new DataTableBuilder(this.scenarioOutline, this.headers, rows, this.title, this.description, this.descriptors);
        }

        public DataTableBuilder andTitle(String title) {
            return new DataTableBuilder(this.scenarioOutline, this.headers, this.rows, title, this.description, this.descriptors);
        }

        public DataTableBuilder andDescription(String description) {
            return new DataTableBuilder(this.scenarioOutline, this.headers, this.rows, this.title, description, this.descriptors);
        }

        public DataTable build() {
            return new DataTable(this.scenarioOutline, this.headers, this.rows, this.title, this.description, this.descriptors);
        }

        public DataTableBuilder andRows(List<List<Object>> rows) {
            List<DataTableRow> dataTableRows = rows.stream().map(DataTableRow::new).collect(Collectors.toList());
            return new DataTableBuilder(this.scenarioOutline, this.headers, dataTableRows, this.title, this.description, this.descriptors);
        }

        public DataTableBuilder andRowData(List<DataTableRow> rows) {
            return new DataTableBuilder(this.scenarioOutline, this.headers, rows, this.title, this.description, this.descriptors);
        }

        public DataTableBuilder andDescriptors(List<DataSetDescriptor> descriptors) {
            return new DataTableBuilder(this.scenarioOutline, this.headers, this.rows, this.title, this.description, descriptors);
        }

        public DataTableBuilder andMappedRows(List<? extends Map<String, ?>> mappedRows) {
            ArrayList<List<Object>> rowData = new ArrayList<List<Object>>();
            for (Map<String, ?> mappedRow : mappedRows) {
                rowData.add(this.rowDataFrom(mappedRow));
            }
            List<DataTableRow> dataTableRows = rowData.stream().map(DataTableRow::new).collect(Collectors.toList());
            return new DataTableBuilder(this.scenarioOutline, this.headers, dataTableRows, this.title, this.description, this.descriptors);
        }

        private List<Object> rowDataFrom(Map<String, ?> mappedRow) {
            ArrayList<Object> rowData = new ArrayList<Object>();
            for (String header : this.headers) {
                rowData.add(mappedRow.get(header));
            }
            return rowData;
        }
    }
}

